/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.service.impl;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceGroupDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.ResourceTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.WorkflowTemplateDTODAI;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;
import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.service.impl.ServiceImpl;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceGroupService
extends ServiceImpl
implements IResourceGroupService {
    @Override
    public List<ResourceGroup> getAllResourceGroups() {
        Class[] classArray = new Class[]{};
        return (List)super.performOperation(classArray, new Object[0]);
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByResourceType(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (List)super.performOperation(classArray, l);
    }

    @Override
    public List<ResourceGroup> getResourceGroupsByHumanResourceType() {
        Class[] classArray = new Class[]{};
        return (List)super.performOperation(classArray, new Object[0]);
    }

    @Override
    public ResourceGroup getResourceGroup(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (ResourceGroup)super.performOperation(classArray, l);
    }

    @Override
    public ResourceGroup getResourceGroupByName(String string) {
        Class[] classArray = new Class[]{String.class};
        return (ResourceGroup)super.performOperation(classArray, string);
    }

    @Override
    public ProtectionKey getProtectionKeyByResourceGroupName(String string) {
        Class[] classArray = new Class[]{String.class};
        return (ProtectionKey)super.performOperation(classArray, string);
    }

    @Override
    public List<String> getAllFunctionalTypesForResourceType(long l) {
        Class[] classArray = new Class[]{Long.TYPE};
        return (List)super.performOperation(classArray, l);
    }

    @Override
    public boolean isNameExists(String string) {
        Class[] classArray = new Class[]{String.class};
        return (Boolean)super.performOperation(classArray, string);
    }

    @Override
    public ResourceGroup createResourceGroup(ResourceGroup resourceGroup) {
        Class[] classArray = new Class[]{ResourceGroup.class};
        return (ResourceGroup)super.performOperation(classArray, resourceGroup);
    }

    @Override
    public ResourceGroup updateResourceGroup(ResourceGroup resourceGroup) {
        Class[] classArray = new Class[]{ResourceGroup.class};
        return (ResourceGroup)super.performOperation(classArray, resourceGroup);
    }

    @Override
    public void deleteResourceGroup(ResourceGroup resourceGroup) {
        Class[] classArray = new Class[]{ResourceGroup.class};
        super.performOperation(classArray, resourceGroup);
    }

    @Override
    public ResourceGroup exportResourceGroup(ResourceGroup resourceGroup, Map<String, Object> map) throws ExportFailureException {
        Class[] classArray = new Class[]{ResourceGroup.class};
        ResourceGroup resourceGroup2 = (ResourceGroup)super.performOperation(classArray, resourceGroup);
        WatchPointDTOExporterFactory watchPointDTOExporterFactory = WatchPointDTOExporterFactory.createFactory();
        IWatchPointDTOExporter<ResourceGroup> iWatchPointDTOExporter = watchPointDTOExporterFactory.getExporter(ResourceGroup.class);
        iWatchPointDTOExporter.export(resourceGroup2, map);
        return resourceGroup2;
    }

    @Override
    public List<ProtectionKey> getAllProtectionKeys() {
        Class[] classArray = new Class[]{};
        return (List)super.performOperation(classArray, new Object[0]);
    }

    protected List<ResourceGroup> getAllResourceGroups(IPersistenceContext iPersistenceContext) {
        return this.createResourceGroupDAO(iPersistenceContext).findAll();
    }

    protected List<ResourceGroup> getResourceGroupsByResourceType(long l, IPersistenceContext iPersistenceContext) {
        return this.createResourceGroupDAO(iPersistenceContext).findByResourceType(l);
    }

    protected List<ResourceGroup> getResourceGroupsByHumanResourceType(IPersistenceContext iPersistenceContext) {
        ApplicationProperties applicationProperties = ApplicationProperties.getInstance();
        String string = applicationProperties.getProperty("Human.ResourceType.SystemId");
        return this.createResourceGroupDAO(iPersistenceContext).findByResourceTypeSystemId(string);
    }

    protected ResourceGroup getResourceGroup(long l, IPersistenceContext iPersistenceContext) {
        return (ResourceGroup)this.createResourceGroupDAO(iPersistenceContext).find(l);
    }

    protected ResourceGroup getResourceGroupByName(String string, IPersistenceContext iPersistenceContext) {
        return this.createResourceGroupDAO(iPersistenceContext).findByName(string);
    }

    protected ProtectionKey getProtectionKeyByResourceGroupName(String string, IPersistenceContext iPersistenceContext) {
        return this.createResourceGroupDAO(iPersistenceContext).findProtectionKeyByName(string);
    }

    protected List<String> getAllFunctionalTypesForResourceType(long l, IPersistenceContext iPersistenceContext) {
        return this.createResourceGroupDAO(iPersistenceContext).getAllFunctionalTypesForResourceType(l);
    }

    protected Boolean isNameExists(String string, IPersistenceContext iPersistenceContext) {
        return this.createResourceGroupDAO(iPersistenceContext).isNameExists(string);
    }

    protected ResourceGroup createResourceGroup(ResourceGroup resourceGroup, IPersistenceContext iPersistenceContext) {
        List<ValidationMessage> list = this.validateForCreate(resourceGroup, iPersistenceContext);
        if (list != null && !list.isEmpty()) {
            throw new ServiceValidationException(list);
        }
        resourceGroup.setVersion(1);
        resourceGroup.setDirty(true);
        if (resourceGroup.getProtectionKey().getId() == -1L) {
            resourceGroup.setProtectionKey(this.createProtectionKeyDAO(iPersistenceContext).create(resourceGroup.getProtectionKey()));
        }
        return this.createResourceGroupDAO(iPersistenceContext).create(resourceGroup);
    }

    protected ResourceGroup updateResourceGroup(ResourceGroup resourceGroup, IPersistenceContext iPersistenceContext) {
        ResourceGroup resourceGroup2 = (ResourceGroup)this.createResourceGroupDAO(iPersistenceContext).find(resourceGroup.getKey());
        List<ValidationMessage> list = this.validateForUpdate(resourceGroup, resourceGroup2, iPersistenceContext);
        if (list != null && !list.isEmpty()) {
            throw new ServiceValidationException(list);
        }
        if (resourceGroup2.isDirty()) {
            resourceGroup.setVersion(resourceGroup2.getVersion());
        } else {
            resourceGroup.setVersion(resourceGroup2.getVersion() + 1);
        }
        resourceGroup.setDirty(true);
        if (resourceGroup.getProtectionKey().getId() == -1L) {
            resourceGroup.setProtectionKey(this.createProtectionKeyDAO(iPersistenceContext).create(resourceGroup.getProtectionKey()));
        }
        return this.createResourceGroupDAO(iPersistenceContext).update(resourceGroup);
    }

    protected void deleteResourceGroup(ResourceGroup resourceGroup, IPersistenceContext iPersistenceContext) {
        boolean bl;
        boolean bl2;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        ResourceGroupDAI resourceGroupDAI = this.createResourceGroupDAO(iPersistenceContext);
        ResourceGroup resourceGroup2 = (ResourceGroup)resourceGroupDAI.find(resourceGroup.getKey());
        if (resourceGroup2.getVersion() == 1 && resourceGroup2.isDirty()) {
            bl2 = false;
        } else {
            bl2 = true;
            arrayList.add(new ValidationMessage(resourceGroup2, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_CANTDEL_EXPORTED));
        }
        WorkflowTemplateDTODAI workflowTemplateDTODAI = this.createWorkflowTemplateDAO(iPersistenceContext);
        int n = workflowTemplateDTODAI.getCountByResourceGroupUsage(resourceGroup.getId());
        if (n > 0) {
            bl = true;
            arrayList.add(new ValidationMessage(resourceGroup2, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_CANTDEL_USEDBYTEMPLATE));
        } else {
            bl = false;
        }
        if (bl2 || bl) {
            throw new ServiceValidationException(arrayList);
        }
        resourceGroupDAI.delete(resourceGroup2.getKey());
    }

    protected ResourceGroup exportResourceGroup(ResourceGroup resourceGroup, IPersistenceContext iPersistenceContext) throws ExportFailureException {
        ResourceGroupDAI resourceGroupDAI = this.createResourceGroupDAO(iPersistenceContext);
        ResourceGroup resourceGroup2 = (ResourceGroup)resourceGroupDAI.find(resourceGroup.getKey());
        resourceGroup2.setDirty(false);
        resourceGroupDAI.update(resourceGroup2);
        return resourceGroup2;
    }

    protected List<ProtectionKey> getAllProtectionKeys(IPersistenceContext iPersistenceContext) {
        return this.createProtectionKeyDAO(iPersistenceContext).findAll();
    }

    private WorkflowTemplateDTODAI createWorkflowTemplateDAO(IPersistenceContext iPersistenceContext) {
        Class<WorkflowTemplateDTO> clazz = WorkflowTemplateDTO.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (WorkflowTemplateDTODAI)dataAccessInterface;
    }

    private ResourceGroupDAI createResourceGroupDAO(IPersistenceContext iPersistenceContext) {
        Class<ResourceGroup> clazz = ResourceGroup.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ResourceGroupDAI)dataAccessInterface;
    }

    private ResourceTypeDAI createResourceTypeDAO(IPersistenceContext iPersistenceContext) {
        Class<ResourceType> clazz = ResourceType.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ResourceTypeDAI)dataAccessInterface;
    }

    private ProtectionKeyDAI createProtectionKeyDAO(IPersistenceContext iPersistenceContext) {
        Class<ProtectionKey> clazz = ProtectionKey.class;
        DataAccessInterface dataAccessInterface = this.daFactory.createDataAccessObject(clazz, iPersistenceContext);
        return (ProtectionKeyDAI)dataAccessInterface;
    }

    protected List<ValidationMessage> validateForCreate(ResourceGroup resourceGroup, IPersistenceContext iPersistenceContext) {
        List<ValidationMessage> list = this.validateResourceGroup(resourceGroup);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        if (this.isNameExists(resourceGroup.getName(), iPersistenceContext).booleanValue()) {
            arrayList.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_NAME_NOT_UNIQUE));
        }
        if (this.createResourceTypeDAO(iPersistenceContext).find(resourceGroup.getResourceType().getKey()) == null) {
            arrayList.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_RESOURCETYPE_NOTEXISTS));
        }
        return arrayList;
    }

    protected List<ValidationMessage> validateForUpdate(ResourceGroup resourceGroup, ResourceGroup resourceGroup2, IPersistenceContext iPersistenceContext) {
        List<ValidationMessage> list = this.validateResourceGroup(resourceGroup);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        if (!resourceGroup.getName().equals(resourceGroup2.getName())) {
            arrayList.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_NAME_CHANGED));
        }
        if (!resourceGroup2.getResourceType().equals(resourceGroup.getResourceType())) {
            arrayList.add(new ValidationMessage(resourceGroup, ValidationMessageType.Error, ValidationMessageCode.RESOURCEGROUP_RESOURCETYPE_CHANGED));
        }
        return arrayList;
    }

    protected List<ValidationMessage> validateResourceGroup(ResourceGroup resourceGroup) {
        ValidationServiceFactory validationServiceFactory = ValidationServiceFactory.createFactory();
        IValidationService iValidationService = validationServiceFactory.createValidationService();
        return iValidationService.validateResourceGroup(resourceGroup);
    }
}

