/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.util.CoreUtility;

public class TemplateResourcesUtility {
    private static final String WATCH_POINT_TEMP_PROJECT = "WatchPointTempProject";
    private static final String TEMP_GPD_FILE = "gpd.xml";
    private static final String TEMPLATE_FOLDER = "TempTemplates";
    private static final String NODE_DEFINITION_FOLDER = "TempNodeDefinitions";
    private static final String TEMP_TEMPLATE_FILE = "processdefinition.xml";
    private static final String TEMP_NODE_DEFINITION_FILE = "nodedefinition.xml";
    private static IJavaProject PROJECT = null;

    public static IFile createTemplateFile(String string, String string2) {
        return TemplateResourcesUtility.createTempFiles(TEMPLATE_FOLDER, TEMP_TEMPLATE_FILE, string, TEMP_GPD_FILE, string2);
    }

    public static IFile createNodeDefinitionFile(String string, String string2) {
        return TemplateResourcesUtility.createTempFiles(NODE_DEFINITION_FOLDER, TEMP_NODE_DEFINITION_FILE, string, TEMP_GPD_FILE, string2);
    }

    public static String getTemplateGpdXml() {
        if (PROJECT == null) {
            return null;
        }
        return TemplateResourcesUtility.getGpdXml(TEMPLATE_FOLDER);
    }

    public static String getNodeDefinitionGpdXml() {
        if (PROJECT == null) {
            return null;
        }
        return TemplateResourcesUtility.getGpdXml(NODE_DEFINITION_FOLDER);
    }

    private static String getGpdXml(String string) {
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PROJECT.getPath() + "//" + string + "//" + TEMP_GPD_FILE));
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(iFile.getContents()));
            StringBuffer stringBuffer = new StringBuffer();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append(System.getProperty("line.separator"));
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            throw new UIException("Could not read from gpd file.", iOException);
        }
        catch (CoreException coreException) {
            throw new UIException("Could not open gpd file.", coreException);
        }
    }

    private static IFile createTempFiles(String string, String string2, String string3, String string4, String string5) {
        IFile iFile = null;
        try {
            PROJECT = TemplateResourcesUtility.createJavaProject(WATCH_POINT_TEMP_PROJECT);
            iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PROJECT.getPath() + "//" + string + "//" + string2));
            if (iFile.exists()) {
                iFile.setContents((InputStream)new ByteArrayInputStream(string3.getBytes()), true, false, null);
            } else {
                iFile.create((InputStream)new ByteArrayInputStream(string3.getBytes()), true, null);
            }
            IFile iFile2 = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(PROJECT.getPath() + "//" + string + "//" + string4));
            if (iFile2.exists()) {
                iFile2.setContents((InputStream)new ByteArrayInputStream(string5.getBytes()), true, false, null);
            } else {
                iFile2.create((InputStream)new ByteArrayInputStream(string5.getBytes()), true, null);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iFile;
    }

    private static IJavaProject createJavaProject(String string) throws CoreException {
        String string2;
        IFolder iFolder;
        String string3;
        IFolder iFolder2;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (!iProject.exists()) {
            iProject.create(null);
        } else {
            iProject.refreshLocal(2, null);
        }
        if (!iProject.isOpen()) {
            iProject.open(null);
        }
        if (!(iFolder2 = iProject.getFolder(string3 = TEMPLATE_FOLDER)).exists()) {
            CoreUtility.createFolder((IFolder)iFolder2, (boolean)false, (boolean)true, null);
        }
        if (!(iFolder = iProject.getFolder(string2 = NODE_DEFINITION_FOLDER)).exists()) {
            CoreUtility.createFolder((IFolder)iFolder, (boolean)false, (boolean)true, null);
        }
        if (!iProject.hasNature("org.eclipse.jdt.core.javanature")) {
            TemplateResourcesUtility.addNatureToProject(iProject, "org.eclipse.jdt.core.javanature", null);
        }
        try {
            IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
            iJavaProject.open(null);
            return iJavaProject;
        }
        catch (Exception exception) {
            throw new IllegalStateException("error de project java : " + exception);
        }
    }

    private static void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        String[] stringArray = iProjectDescription.getNatureIds();
        String[] stringArray2 = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        stringArray2[stringArray.length] = string;
        iProjectDescription.setNatureIds(stringArray2);
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }
}

