/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.actionconfig;

import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationException;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActionConfigurationManager {
    private static final Logger logger = Logger.getLogger(ActionConfigurationManager.class);
    private static ActionConfigurationManager instance = new ActionConfigurationManager();
    private Map<String, ActionClassConfiguration> actionClasses;

    public static ActionConfigurationManager getInstance() {
        return instance;
    }

    private ActionConfigurationManager() {
        this.initialize();
    }

    public synchronized ActionClassConfiguration getActionClass(String string) {
        if (this.actionClasses != null && string != null) {
            return this.actionClasses.get(string);
        }
        return null;
    }

    public synchronized List<ActionClassConfiguration> getAllActionClasses() {
        ArrayList<ActionClassConfiguration> arrayList = new ArrayList<ActionClassConfiguration>();
        if (this.actionClasses != null) {
            arrayList.addAll(this.actionClasses.values());
            Collections.sort(arrayList, new ActionClassComparator());
        }
        return arrayList;
    }

    private void initialize() {
        this.actionClasses = null;
        try {
            ActionConfigurationReader actionConfigurationReader = new ActionConfigurationReader();
            this.actionClasses = actionConfigurationReader.read();
        }
        catch (ActionConfigurationException actionConfigurationException) {
            String string = "Failed to read the Action Class Configuration, no pre-configured Action Classes available.";
            logger.error((Object)string, (Throwable)actionConfigurationException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionClassComparator
    implements Comparator<ActionClassConfiguration> {
        private ActionClassComparator() {
        }

        @Override
        public int compare(ActionClassConfiguration actionClassConfiguration, ActionClassConfiguration actionClassConfiguration2) {
            return actionClassConfiguration.getClassName().compareTo(actionClassConfiguration2.getClassName());
        }
    }
}

