/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.actionconfig;

import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationException;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionVariableConfiguration;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.jbpm.gd.common.model.GenericElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionConfigurationReader {
    private static final Logger logger = Logger.getLogger(ActionConfigurationReader.class);
    private static final String RESOURCE_NAME = "/ActionClasses.xml";
    private static final String ACTION_CLASSES_XPATH = "//class/@name";
    private IValidationService validationService = ValidationServiceFactory.createFactory().createValidationService();

    public Map<String, ActionClassConfiguration> read() throws ActionConfigurationException {
        HashMap<String, ActionClassConfiguration> hashMap = new HashMap<String, ActionClassConfiguration>();
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(this.getClass().getResourceAsStream(RESOURCE_NAME));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate(ACTION_CLASSES_XPATH, document, XPathConstants.NODESET);
            int n = nodeList != null ? nodeList.getLength() : 0;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                String string = node.getNodeValue();
                if (string != null && string.trim().length() != 0) {
                    String string2 = "//class[@name='" + string + "']/variable";
                    NodeList nodeList2 = (NodeList)xPath.evaluate(string2, document, XPathConstants.NODESET);
                    ArrayList<ActionVariableConfiguration> arrayList = new ArrayList<ActionVariableConfiguration>();
                    ArrayList arrayList2 = new ArrayList();
                    int n3 = nodeList2 != null ? nodeList2.getLength() : 0;
                    int n4 = 0;
                    while (n4 < n3) {
                        Node node2 = nodeList2.item(n4);
                        if (node2 instanceof Element) {
                            Element element = (Element)node2;
                            String string3 = element.getAttribute("name");
                            if (this.isInvalidVariableName(string3)) {
                                String string4 = "The Action Class with name: " + string + " contains a variable with an invalid name: " + string3 + ", skipping variable.";
                                logger.warn((Object)string4);
                            } else if (arrayList2.contains(string3)) {
                                String string5 = "The Action Class with name: " + string + " contains a more than one variable with name: " + string3 + ", skipping duplicate variables.";
                                logger.warn((Object)string5);
                            } else {
                                boolean bl = Boolean.parseBoolean(element.getAttribute("required"));
                                String string6 = element.getAttribute("validationRule");
                                arrayList.add(new ActionVariableConfiguration(string3, bl, string6));
                            }
                        }
                        ++n4;
                    }
                    hashMap.put(string, new ActionClassConfiguration(string, arrayList));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            String string = "Failed to load Action Class configuration from file: /ActionClasses.xml";
            throw new ActionConfigurationException(string, exception);
        }
        return hashMap;
    }

    private boolean isInvalidVariableName(String string) {
        GenericElement genericElement = new GenericElement();
        genericElement.setName(string);
        List<ValidationMessage> list = this.validationService.validateActionVariableName(genericElement);
        return list != null && list.size() > 0;
    }
}

