/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionGraphicalViewer;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionPaletteRoot;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.editor.OutlineViewer;

public class NodeDefinitionGraphPage
extends EditorPart {
    private NodeDefinitionEditor editor;
    private NodeDefinitionGraphicalViewer graphicalViewer;
    private OutlineViewer outlineViewer;

    public NodeDefinitionGraphPage(NodeDefinitionEditor nodeDefinitionEditor) {
        this.editor = nodeDefinitionEditor;
    }

    public void createPartControl(Composite composite) {
        SashForm sashForm = new SashForm(composite, 256);
        NodeDefinition nodeDefinition = (NodeDefinition)this.editor.getRootContainer().getSemanticElement();
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState) {
            this.addPalette((Composite)sashForm);
            this.addModelViewer((Composite)sashForm);
            sashForm.setWeights(new int[]{15, 85});
        } else {
            this.addModelViewer((Composite)sashForm);
            sashForm.setWeights(new int[]{100});
        }
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        SWTGraphics sWTGraphics = null;
        GC gC = null;
        Image image = null;
        LayerManager layerManager = (LayerManager)this.graphicalViewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure iFigure = layerManager.getLayer((Object)"Printable Layers");
        try {
            Rectangle rectangle = iFigure.getBounds();
            this.editor.getRootContainer().setDimension(new Dimension(rectangle.width, rectangle.height));
            image = new Image((Device)Display.getDefault(), rectangle.width, rectangle.height);
            gC = new GC((Drawable)image);
            sWTGraphics = new SWTGraphics(gC);
            sWTGraphics.translate(rectangle.x * -1, rectangle.y * -1);
            iFigure.paint((Graphics)sWTGraphics);
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{image.getImageData()};
            imageLoader.save(this.getImageSavePath(), 4);
            this.refreshProcessFolder();
        }
        finally {
            if (sWTGraphics != null) {
                sWTGraphics.dispose();
            }
            if (gC != null) {
                gC.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
    }

    public NodeDefinitionGraphicalViewer getDesignerModelViewer() {
        return this.graphicalViewer;
    }

    public OutlineViewer getOutlineViewer() {
        return this.outlineViewer;
    }

    public NodeDefinitionEditor getEditor() {
        return this.editor;
    }

    private void addModelViewer(Composite composite) {
        this.graphicalViewer = this.editor.createGraphicalViewer();
        this.graphicalViewer.initControl(composite);
        this.getSite().setSelectionProvider((ISelectionProvider)this.graphicalViewer);
    }

    private void addPalette(Composite composite) {
        PaletteViewer paletteViewer = new PaletteViewer();
        paletteViewer.createControl(composite);
        this.editor.getEditDomain().setPaletteViewer(paletteViewer);
        this.editor.getEditDomain().setPaletteRoot((PaletteRoot)new NodeDefinitionPaletteRoot(this.editor));
    }

    private void refreshProcessFolder() {
        try {
            IFile iFile = ((FileEditorInput)this.getEditorInput()).getFile();
            iFile.getParent().refreshLocal(1, null);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private String getImageSavePath() {
        IFile iFile = ((FileEditorInput)this.getEditorInput()).getFile();
        String string = iFile.getName();
        string = string.startsWith(".gpd.") && string.length() > 7 ? String.valueOf(string.substring(5, string.length() - 3)) + "jpg" : this.editor.getDefaultImageFileName();
        IPath iPath = iFile.getRawLocation().removeLastSegments(1).append(string);
        return iPath.toOSString();
    }
}

