/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.model.Variable;

public abstract class AbstractVariableTableItemWrapper
implements DisposeListener,
SelectionListener,
FocusListener {
    protected TableItem tableItem;
    protected Text mappedNameText;
    protected WPVariable variable;

    public AbstractVariableTableItemWrapper(Table table, Variable variable) {
        this.variable = (WPVariable)variable;
        this.initializeTableItem(table);
        this.initializeMappedNameText(table);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.mappedNameText && this.mappedNameText.getEditable()) {
            this.variable.setMappedName(this.mappedNameText.getText());
            this.applyMappedName();
        }
        this.cancelEditing();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        if (this.mappedNameText == null || this.mappedNameText.isDisposed()) {
            return;
        }
        this.mappedNameText.removeSelectionListener((SelectionListener)this);
        this.mappedNameText.removeFocusListener((FocusListener)this);
        this.mappedNameText.dispose();
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void editCell(int n) {
        if (n == 1) {
            this.editMappedName();
        }
    }

    protected void initializeTableItem(Table table) {
        this.tableItem = new TableItem(table, 0);
        this.tableItem.addDisposeListener((DisposeListener)this);
        this.tableItem.setData((Object)this);
    }

    protected void initializeMappedNameText(Table table) {
        this.mappedNameText = this.createText(table, 1);
        this.mappedNameText.addSelectionListener((SelectionListener)this);
        this.mappedNameText.addFocusListener((FocusListener)this);
        this.mappedNameText.setText(this.getMappedName());
        this.mappedNameText.setEditable(false);
        this.mappedNameText.pack();
    }

    protected Button createButton(Table table, int n) {
        TableEditor tableEditor = new TableEditor(table);
        Button button = new Button((Composite)table, 32);
        button.pack();
        tableEditor.minimumWidth = button.getSize().x;
        tableEditor.horizontalAlignment = 0x1000000;
        tableEditor.setEditor((Control)button, this.tableItem, n);
        return button;
    }

    protected Text createText(Table table, int n) {
        TableEditor tableEditor = new TableEditor(table);
        Text text = new Text((Composite)table, 0);
        text.pack();
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.setEditor((Control)text, this.tableItem, n);
        return text;
    }

    protected CCombo createCombo(Table table, int n) {
        TableEditor tableEditor = new TableEditor(table);
        CCombo cCombo = new CCombo((Composite)table, 780);
        cCombo.pack();
        tableEditor.horizontalAlignment = 16384;
        tableEditor.grabHorizontal = true;
        tableEditor.setEditor((Control)cCombo, this.tableItem, n);
        return cCombo;
    }

    protected void editMappedName() {
        this.mappedNameText.setVisible(true);
        this.mappedNameText.setText(this.getMappedName());
        this.mappedNameText.setFocus();
        this.mappedNameText.selectAll();
    }

    protected void cancelEditing() {
        this.applyMappedName();
    }

    protected void applyMappedName() {
        if (this.mappedNameText == null && !this.mappedNameText.isDisposed()) {
            return;
        }
        this.mappedNameText.setVisible(false);
        this.tableItem.setText(1, this.getMappedName());
    }

    protected String getMappedName() {
        if (this.variable.getMappedName() == null || this.variable.getMappedName().equals("")) {
            return this.variable.getName() == null ? "" : this.variable.getName();
        }
        return this.variable.getMappedName();
    }
}

