/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.util.TimerExpression;
import com.tandbergtv.watchpoint.studio.util.TimerExpressionMarshaller;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class DueDateElementConfigurationComposite
implements FocusListener,
SelectionListener {
    private static final Logger logger = Logger.getLogger(DueDateElementConfigurationComposite.class);
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo dueDateFirstText;
    private CCombo dueDateOperator;
    private CCombo dueDateSecondText;
    private Label dueDateLabel;
    private IDueDateElement dueDateElement;
    private AbstractPropertySection parentPropertySection;
    private String currentOperator = null;
    private static final String[] ADD_OPERATOR_VARIABLE_FILTER = new String[]{"DURATION"};
    private static final String[] MLPY_OPERATOR_VARIABLE_FILTER = new String[]{"INT", "STRING"};

    private DueDateElementConfigurationComposite() {
    }

    public static DueDateElementConfigurationComposite create(AbstractPropertySection abstractPropertySection, TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory, Composite composite) {
        DueDateElementConfigurationComposite dueDateElementConfigurationComposite = new DueDateElementConfigurationComposite();
        dueDateElementConfigurationComposite.parentPropertySection = abstractPropertySection;
        dueDateElementConfigurationComposite.widgetFactory = tabbedPropertySheetWidgetFactory;
        dueDateElementConfigurationComposite.parent = composite;
        dueDateElementConfigurationComposite.create();
        return dueDateElementConfigurationComposite;
    }

    public void setDueDateElement(IDueDateElement iDueDateElement) {
        if (iDueDateElement instanceof NodeDefinition) {
            if (((NodeDefinition)iDueDateElement).getNode() == null) {
                this.dueDateFirstText.setEnabled(false);
                this.dueDateSecondText.setEnabled(false);
                this.dueDateOperator.setEnabled(false);
            } else {
                this.dueDateFirstText.setEnabled(true);
                this.dueDateSecondText.setEnabled(true);
                this.dueDateOperator.setEnabled(true);
            }
        }
        this.clearControls();
        this.dueDateElement = iDueDateElement;
        if (iDueDateElement != null) {
            this.updateControls();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.dueDateElement == null) {
            return;
        }
        if (focusEvent.widget == this.dueDateFirstText || focusEvent.widget == this.dueDateSecondText || focusEvent.widget == this.dueDateOperator) {
            String string = this.dueDateFirstText.getText();
            String string2 = this.dueDateOperator.getText();
            String string3 = this.dueDateSecondText.getText();
            String string4 = String.valueOf(string) + string2 + string3;
            this.dueDateElement.setDueDate(string4);
            if (string2.length() <= 0 || string3.length() != 0) {
                this.validate();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string = this.dueDateOperator.getText();
        if (!string.equals(this.currentOperator)) {
            this.setVariables();
            this.dueDateSecondText.setText("");
            this.currentOperator = string;
        }
    }

    private void clearControls() {
        this.dueDateFirstText.removeAll();
        this.dueDateSecondText.removeAll();
        this.dueDateOperator.select(0);
        this.currentOperator = this.dueDateOperator.getText();
    }

    private void updateControls() {
        String string = this.dueDateElement.getDueDate();
        if (string != null) {
            TimerExpression timerExpression = TimerExpressionMarshaller.unmarshall(string);
            this.dueDateFirstText.setText(timerExpression.getOperand1() != null ? timerExpression.getOperand1() : "");
            this.dueDateSecondText.setText(timerExpression.getOperand2() != null ? timerExpression.getOperand2() : "");
            this.dueDateOperator.setText(timerExpression.getOperator() != null ? timerExpression.getOperator() : "");
        } else {
            this.dueDateFirstText.setText("");
            this.dueDateSecondText.setText("");
            this.dueDateOperator.setText("");
        }
        this.currentOperator = this.dueDateOperator.getText();
        this.dueDateFirstText.setItems(this.getVariables(ADD_OPERATOR_VARIABLE_FILTER));
        this.setVariables();
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.dueDateLabel = new Label(composite, 0);
        this.dueDateLabel.setText("Due Date");
        this.dueDateLabel.setLayoutData((Object)this.createDueDateLabelLayoutData());
        this.dueDateLabel.setBackground(ColorConstants.white);
        this.dueDateLabel.pack();
        this.dueDateFirstText = this.widgetFactory.createCCombo(this.parent, 4);
        this.dueDateFirstText.setLayoutData((Object)this.createDueDateTextLayoutData(0, 85, 200));
        this.dueDateFirstText.setItems(new String[0]);
        this.dueDateFirstText.setEditable(true);
        this.dueDateFirstText.addFocusListener((FocusListener)this);
        this.dueDateFirstText.pack();
        this.dueDateOperator = this.widgetFactory.createCCombo(this.parent, 4);
        this.dueDateOperator.setLayoutData((Object)this.createDueDateTextLayoutData(0, 310, 35));
        this.dueDateOperator.setItems(this.getOptions());
        this.dueDateOperator.setEditable(false);
        this.dueDateOperator.addSelectionListener((SelectionListener)this);
        this.dueDateOperator.addFocusListener((FocusListener)this);
        this.dueDateOperator.pack();
        this.currentOperator = this.dueDateOperator.getText();
        this.dueDateSecondText = this.widgetFactory.createCCombo(this.parent, 4);
        this.dueDateSecondText.setLayoutData((Object)this.createDueDateTextLayoutData(0, 370, 200));
        this.dueDateSecondText.setItems(new String[0]);
        this.dueDateSecondText.setEditable(true);
        this.dueDateSecondText.addFocusListener((FocusListener)this);
        this.dueDateSecondText.pack();
    }

    private FormData createDueDateLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, -6);
        formData.top = new FormAttachment(0, 0);
        return formData;
    }

    private FormData createDueDateTextLayoutData(int n, int n2, int n3) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(n, n2);
        formData.top = new FormAttachment(0, 0);
        formData.width = n3;
        return formData;
    }

    private String[] getOptions() {
        String[] stringArray = new String[]{"", "+", "*"};
        return stringArray;
    }

    private String[] getVariables(String[] stringArray) {
        String[] stringArray2;
        IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
        List<WPVariable> list = Utility.getVariables(Utility.getNodeElementContainer(iWorkbenchPart));
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray2 = stringArray3[n2];
            for (WPVariable wPVariable : list) {
                if (!stringArray2.equals(wPVariable.getType()) || wPVariable.getName() == null) continue;
                hashSet.add(wPVariable.getName());
            }
            ++n2;
        }
        stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        return stringArray2;
    }

    private void validate() {
        Object object;
        ValidationServiceFactory validationServiceFactory = ValidationServiceFactory.createFactory();
        IValidationService iValidationService = validationServiceFactory.createValidationService();
        IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(iWorkbenchPart);
        List<ValidationMessage> list = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            object = (WorkflowTemplate)nodeElementContainer;
            list = iValidationService.validateDueDate(this.dueDateElement, (WorkflowTemplate)object);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            object = (NodeDefinition)nodeElementContainer;
            list = iValidationService.validateDueDate(this.dueDateElement, (NodeDefinition)object);
        }
        if (list != null && list.size() > 0) {
            try {
                object = ValidationMessages.getInstance().getMessage(list.get(0));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error in Due Date Expression", (String)object);
            }
            catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)invalidPropertiesFormatException);
                throw new UIException("Error occured while opening the Message Dialog");
            }
            catch (IOException iOException) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)iOException);
                throw new UIException("Error occured while opening the Message Dialog");
            }
        }
    }

    private void setVariables() {
        String string = this.dueDateOperator.getText();
        boolean bl = string.length() > 0;
        String[] stringArray = new String[]{};
        if (string.equals("+")) {
            stringArray = this.getVariables(ADD_OPERATOR_VARIABLE_FILTER);
        } else if (string.equals("*")) {
            stringArray = this.getVariables(MLPY_OPERATOR_VARIABLE_FILTER);
        }
        this.dueDateSecondText.setEnabled(bl);
        this.dueDateSecondText.setItems(stringArray);
    }
}

