/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.util.TimerExpression;
import com.tandbergtv.watchpoint.studio.util.TimerExpressionMarshaller;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;

public class DurationElementConfigurationComposite
implements FocusListener,
SelectionListener {
    private static final Logger logger = Logger.getLogger(DurationElementConfigurationComposite.class);
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Text taskDurationText;
    private CCombo durationText;
    private CCombo durationSecondText;
    private CCombo durationOperator;
    private Label durationLabel;
    private Label taskDurationLabel;
    private IDurationElement durationElement;
    private AbstractPropertySection parentPropertySection;
    private String currentOperator = null;
    private static final String[] ADD_OPERATOR_VARIABLE_FILTER = new String[]{"DURATION"};
    private static final String[] MLPY_OPERATOR_VARIABLE_FILTER = new String[]{"INT", "STRING"};

    private DurationElementConfigurationComposite() {
    }

    public static DurationElementConfigurationComposite create(AbstractPropertySection abstractPropertySection, TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory, Composite composite) {
        DurationElementConfigurationComposite durationElementConfigurationComposite = new DurationElementConfigurationComposite();
        durationElementConfigurationComposite.parentPropertySection = abstractPropertySection;
        durationElementConfigurationComposite.widgetFactory = tabbedPropertySheetWidgetFactory;
        durationElementConfigurationComposite.parent = composite;
        durationElementConfigurationComposite.create();
        return durationElementConfigurationComposite;
    }

    public void setDurationElement(IDurationElement iDurationElement) {
        if (iDurationElement instanceof NodeDefinition) {
            if (((NodeDefinition)iDurationElement).getNode() == null) {
                this.durationText.setEnabled(false);
                this.durationSecondText.setEnabled(false);
                this.durationOperator.setEnabled(false);
                this.taskDurationText.setEnabled(false);
            } else {
                this.durationText.setEnabled(true);
                this.durationSecondText.setEnabled(true);
                this.durationOperator.setEnabled(true);
                this.taskDurationText.setEnabled(true);
            }
        }
        this.clearControls();
        this.durationElement = iDurationElement;
        if (iDurationElement != null) {
            this.updateControls();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.durationElement == null) {
            return;
        }
        if (focusEvent.widget == this.durationText || focusEvent.widget == this.durationSecondText || focusEvent.widget == this.durationOperator) {
            String string = this.durationText.getText();
            String string2 = this.durationOperator.getText();
            String string3 = this.durationSecondText.getText();
            String string4 = String.valueOf(string) + string2 + string3;
            this.durationElement.setDuration(string4);
            if (string2.length() <= 0 || string3.length() != 0) {
                this.validate();
            }
        } else if (focusEvent.widget == this.taskDurationText) {
            this.durationElement.setTaskDuration(this.taskDurationText.getText());
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        String string = this.durationOperator.getText();
        if (!string.equals(this.currentOperator)) {
            this.setVariables();
            this.durationSecondText.setText("");
            this.currentOperator = string;
        }
    }

    private void clearControls() {
        this.durationText.removeAll();
        this.durationSecondText.removeAll();
        this.durationOperator.select(0);
        this.taskDurationText.setText("");
        this.currentOperator = this.durationOperator.getText();
    }

    private void updateControls() {
        Object object;
        String string = this.durationElement.getDuration();
        if (string != null) {
            object = TimerExpressionMarshaller.unmarshall(string);
            this.durationText.setText(((TimerExpression)object).getOperand1() != null ? ((TimerExpression)object).getOperand1() : "");
            this.durationSecondText.setText(((TimerExpression)object).getOperand2() != null ? ((TimerExpression)object).getOperand2() : "");
            this.durationOperator.setText(((TimerExpression)object).getOperator() != null ? ((TimerExpression)object).getOperator() : "");
        } else {
            this.durationText.setText("");
            this.durationSecondText.setText("");
            this.durationOperator.setText("");
        }
        object = this.durationElement.getTaskDuration();
        if (object != null) {
            this.taskDurationText.setText((String)object);
        } else {
            this.taskDurationText.setText("");
        }
        this.currentOperator = this.durationOperator.getText();
        this.durationText.setItems(this.getVariables(ADD_OPERATOR_VARIABLE_FILTER));
        this.setVariables();
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.durationLabel = new Label(composite, 0);
        this.durationLabel.setText("Duration");
        this.durationLabel.setLayoutData((Object)this.createDurationpLabelLayoutData());
        this.durationLabel.setBackground(ColorConstants.white);
        this.durationLabel.pack();
        this.taskDurationLabel = new Label(composite, 0);
        this.taskDurationLabel.setText("Task Duration");
        this.taskDurationLabel.setLayoutData((Object)this.createTaskDurationpLabelLayoutData());
        this.taskDurationLabel.setBackground(ColorConstants.white);
        this.taskDurationLabel.pack();
        this.durationText = this.widgetFactory.createCCombo(this.parent, 4);
        this.durationText.setLayoutData((Object)this.createDurationTextLayoutData(0, 85, 200));
        this.durationText.setItems(new String[0]);
        this.durationText.setEditable(true);
        this.durationText.addFocusListener((FocusListener)this);
        this.durationText.pack();
        this.durationOperator = this.widgetFactory.createCCombo(this.parent, 4);
        this.durationOperator.setLayoutData((Object)this.createDurationTextLayoutData(0, 310, 35));
        this.durationOperator.setItems(this.getOptions());
        this.durationOperator.setEditable(false);
        this.durationOperator.addSelectionListener((SelectionListener)this);
        this.durationOperator.addFocusListener((FocusListener)this);
        this.durationOperator.pack();
        this.currentOperator = this.durationOperator.getText();
        this.durationSecondText = this.widgetFactory.createCCombo(this.parent, 4);
        this.durationSecondText.setLayoutData((Object)this.createDurationTextLayoutData(0, 370, 200));
        this.durationSecondText.setItems(new String[0]);
        this.durationSecondText.setEditable(true);
        this.durationSecondText.addFocusListener((FocusListener)this);
        this.durationSecondText.pack();
        this.taskDurationText = this.widgetFactory.createText(this.parent, "");
        this.taskDurationText.setLayoutData((Object)this.createTaskDurationTextLayoutData());
        this.taskDurationText.addFocusListener((FocusListener)this);
        this.taskDurationText.pack();
    }

    private FormData createDurationpLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, -6);
        formData.top = new FormAttachment(0, 0);
        return formData;
    }

    private FormData createTaskDurationpLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, -6);
        formData.top = new FormAttachment((Control)this.durationLabel, 2);
        return formData;
    }

    private FormData createDurationTextLayoutData(int n, int n2, int n3) {
        FormData formData = new FormData();
        formData.left = new FormAttachment(n, n2);
        formData.top = new FormAttachment(0, 0);
        formData.width = n3;
        return formData;
    }

    private FormData createTaskDurationTextLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.top = new FormAttachment((Control)this.durationText, 2);
        formData.width = 450;
        return formData;
    }

    private String[] getOptions() {
        String[] stringArray = new String[]{"", "+", "*"};
        return stringArray;
    }

    private String[] getVariables(String[] stringArray) {
        String[] stringArray2;
        IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
        List<WPVariable> list = Utility.getVariables(Utility.getNodeElementContainer(iWorkbenchPart));
        HashSet<String> hashSet = new HashSet<String>();
        String[] stringArray3 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringArray2 = stringArray3[n2];
            for (WPVariable wPVariable : list) {
                if (!stringArray2.equals(wPVariable.getType()) || wPVariable.getName() == null) continue;
                hashSet.add(wPVariable.getName());
            }
            ++n2;
        }
        stringArray2 = hashSet.toArray(new String[hashSet.size()]);
        return stringArray2;
    }

    private void validate() {
        Object object;
        ValidationServiceFactory validationServiceFactory = ValidationServiceFactory.createFactory();
        IValidationService iValidationService = validationServiceFactory.createValidationService();
        IWorkbenchPart iWorkbenchPart = this.parentPropertySection.getPart();
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(iWorkbenchPart);
        List<ValidationMessage> list = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            object = (WorkflowTemplate)nodeElementContainer;
            list = iValidationService.validateDuration(this.durationElement, (WorkflowTemplate)object);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            object = (NodeDefinition)nodeElementContainer;
            list = iValidationService.validateDuration(this.durationElement, (NodeDefinition)object);
        }
        if (list != null && list.size() > 0) {
            try {
                object = ValidationMessages.getInstance().getMessage(list.get(0));
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error in Duration Expression", (String)object);
            }
            catch (InvalidPropertiesFormatException invalidPropertiesFormatException) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)invalidPropertiesFormatException);
                throw new UIException("Error occured while opening the Message Dialog");
            }
            catch (IOException iOException) {
                logger.error((Object)"Error occured while opening the Message Dialog", (Throwable)iOException);
                throw new UIException("Error occured while opening the Message Dialog");
            }
        }
    }

    private void setVariables() {
        String string = this.durationOperator.getText();
        boolean bl = string.length() > 0;
        String[] stringArray = new String[]{};
        if (string.equals("+")) {
            stringArray = this.getVariables(ADD_OPERATOR_VARIABLE_FILTER);
        } else if (string.equals("*")) {
            stringArray = this.getVariables(MLPY_OPERATOR_VARIABLE_FILTER);
        }
        this.durationSecondText.setEnabled(bl);
        this.durationSecondText.setItems(stringArray);
    }
}

