/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.model.IMessageContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractInVariableWrapper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jbpm.gd.jpdl.model.Variable;

public class EditableInVarTableItemWrapper
extends AbstractInVariableWrapper {
    private IMessageContainer messageContainer;

    public EditableInVarTableItemWrapper(Table table, Variable variable, IMessageContainer iMessageContainer) {
        super(table, variable);
        this.messageContainer = iMessageContainer;
        this.initializeControls();
    }

    public boolean isCompositeKey() {
        return this.compositeButton.getSelection();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.compositeButton) {
            if (this.compositeButton.getSelection()) {
                this.messageContainer.setCompositeKey(this.getMappedName(), "");
                this.messageContainer.removeVariable(this.getMappedName());
            } else {
                this.messageContainer.setCompositeKey(this.getMappedName(), null);
                this.messageContainer.addVariable(this.variable);
            }
        } else {
            super.widgetSelected(selectionEvent);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.mappedNameText) {
            if (!this.mappedNameText.getText().equals(this.variable.getMappedName()) && this.hasVariable(this.mappedNameText.getText())) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("This message already contains a variable " + this.mappedNameText.getText() + "."));
                this.mappedNameText.setText(this.variable.getMappedName());
                return;
            }
            if (this.compositeButton.getSelection()) {
                this.messageContainer.setCompositeKey(this.variable.getMappedName(), null);
                this.messageContainer.setCompositeKey(this.mappedNameText.getText(), "");
            }
        }
        super.focusLost(focusEvent);
    }

    private void initializeControls() {
        this.compositeButton.setEnabled(true);
        this.mappedNameText.setEditable(true);
        this.compositeButton.setSelection(this.messageContainer.getCompositeKey(this.variable.getMappedName()) != null);
    }

    private boolean hasVariable(String string) {
        for (WPVariable wPVariable : this.messageContainer.getOutgoingVariables()) {
            if (!wPVariable.getMappedName().equals(string)) continue;
            return true;
        }
        for (WPVariable wPVariable : this.messageContainer.getIncomingVariables()) {
            if (!wPVariable.getMappedName().equals(string)) continue;
            return true;
        }
        return this.messageContainer.getConstantValue(string) != null || this.messageContainer.getCompositeKey(string) != null;
    }
}

