/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.AbstractOutVariableWrapper;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.Variable;

public class OutVariableTableItemWrapper
extends AbstractOutVariableWrapper {
    private boolean isConstant = false;
    private AbstractPropertySection parentPropertySection;

    public OutVariableTableItemWrapper(AbstractPropertySection abstractPropertySection, Table table, Variable variable) {
        super(table, variable);
        this.parentPropertySection = abstractPropertySection;
        this.initializeVariableCombo(table);
        this.attachmentButton.setEnabled(false);
    }

    public OutVariableTableItemWrapper(AbstractPropertySection abstractPropertySection, Table table, String string, String string2) {
        super(table, new WPVariable());
        this.parentPropertySection = abstractPropertySection;
        this.variable.setName(string);
        this.isConstant = true;
        this.initializeVariableCombo(table);
        this.attachmentButton.setEnabled(false);
        this.valueText.setText(string2);
    }

    public void widgetDisposed(DisposeEvent disposeEvent) {
        super.widgetDisposed(disposeEvent);
        if (this.valueText != null && !this.valueText.isDisposed()) {
            this.valueText.removeSelectionListener((SelectionListener)this);
            this.valueText.removeFocusListener((FocusListener)this);
            this.valueText.dispose();
        }
    }

    private void initializeVariableCombo(Table table) {
        this.variableCombo = this.createCombo(table, 4);
        this.variableCombo.addSelectionListener((SelectionListener)this);
        this.variableCombo.addFocusListener((FocusListener)this);
        NodeElementContainer nodeElementContainer = Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        boolean bl = !this.isConstant && nodeElementContainer instanceof NodeDefinition && ((NodeDefinition)nodeElementContainer).getNodeType().equals(NodeDefinitionType.SuperState);
        this.variableCombo.setEnabled(bl);
        if (bl) {
            this.fillVariableCombo();
        }
        if (this.variable.getName() != null && this.variableCombo.isEnabled()) {
            this.variableCombo.setText(this.variable.getName());
        }
    }

    private void fillVariableCombo() {
        NodeDefinition nodeDefinition = (NodeDefinition)Utility.getNodeElementContainer(this.parentPropertySection.getPart());
        for (Variable variable : nodeDefinition.getVariables()) {
            if (variable.getMappedName() == null || this.variable.getType() != null && !this.variable.getType().equals(((WPVariable)variable).getType())) continue;
            this.variableCombo.add(variable.getMappedName());
        }
    }
}

