/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.IHumanResourceTypeElement;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ResourceGroupElementConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private CCombo resourceGroupCombo;
    private Label resourceGroupLabel;
    private IResourceTypeElement resourceTypeElement;
    private com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup resourceGroup;

    private ResourceGroupElementConfigurationComposite() {
    }

    public static ResourceGroupElementConfigurationComposite create(TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory, Composite composite) {
        ResourceGroupElementConfigurationComposite resourceGroupElementConfigurationComposite = new ResourceGroupElementConfigurationComposite();
        resourceGroupElementConfigurationComposite.widgetFactory = tabbedPropertySheetWidgetFactory;
        resourceGroupElementConfigurationComposite.parent = composite;
        resourceGroupElementConfigurationComposite.create();
        return resourceGroupElementConfigurationComposite;
    }

    public void setResourceGroupElement(IResourceTypeElement iResourceTypeElement) {
        this.resourceTypeElement = iResourceTypeElement;
        if (this.resourceTypeElement instanceof NodeDefinition) {
            if (((NodeDefinition)this.resourceTypeElement).getNode() == null) {
                this.resourceGroupCombo.setEnabled(false);
            } else {
                this.resourceGroupCombo.setEnabled(true);
            }
        }
        this.unhookSelectionListener();
        if (iResourceTypeElement != null) {
            this.updateControls();
            this.hookSelectionListener();
            this.fillResourceGroupCombo();
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.resourceGroupCombo) {
            if (this.resourceGroup == null) {
                this.resourceGroup = (com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup)this.resourceTypeElement.getFactory().createById("com.tandbergtv.watchpoint.studio.resourceGroup");
            }
            this.resourceGroup.setName(this.resourceGroupCombo.getItem(this.resourceGroupCombo.getSelectionIndex()));
            this.resourceTypeElement.setResourceGroup(this.resourceGroup);
        }
    }

    private void hookSelectionListener() {
        this.resourceGroupCombo.addSelectionListener((SelectionListener)this);
    }

    private void unhookSelectionListener() {
        this.resourceGroupCombo.removeSelectionListener((SelectionListener)this);
    }

    private void updateControls() {
        this.resourceGroup = this.resourceTypeElement.getResourceGroup();
    }

    private void create() {
        String string;
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.resourceGroupLabel = new Label(composite, 0);
        this.resourceGroupLabel.setText("Resource Group");
        this.resourceGroupLabel.setLayoutData((Object)this.createResourceGroupLabelLayoutData());
        this.resourceGroupLabel.setBackground(ColorConstants.white);
        this.resourceGroupLabel.pack();
        this.resourceGroupCombo = this.widgetFactory.createCCombo(composite, 780);
        this.resourceGroupCombo.setLayoutData((Object)this.createResourceGroupComboLayoutData());
        if (this.resourceTypeElement instanceof NodeDefinition && ((string = ((NodeDefinition)this.resourceTypeElement).getDefinitionName()) == null || string.trim().length() == 0)) {
            this.resourceGroupCombo.setEnabled(false);
        }
        this.resourceGroupCombo.pack();
    }

    private FormData createResourceGroupLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, -6);
        formData.top = new FormAttachment(0, 2);
        return formData;
    }

    private FormData createResourceGroupComboLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 79);
        formData.top = new FormAttachment(0, 0);
        formData.width = 200;
        return formData;
    }

    private void fillResourceGroupCombo() {
        this.resourceGroupCombo.removeAll();
        List<ResourceGroup> list = null;
        list = this.resourceTypeElement instanceof IHumanResourceTypeElement ? ServiceFactory.createFactory().createResourceGroupService().getResourceGroupsByHumanResourceType() : ServiceFactory.createFactory().createResourceGroupService().getResourceGroupsByResourceType(this.resourceTypeElement.getResourceType());
        int n = 0;
        for (ResourceGroup resourceGroup : list) {
            this.resourceGroupCombo.add(resourceGroup.getName());
            if (this.resourceTypeElement.getResourceGroup() != null && resourceGroup.getName().equals(this.resourceTypeElement.getResourceGroup().getName())) {
                this.resourceGroupCombo.select(n);
            }
            ++n;
        }
    }
}

