/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ResourceTypeElementConfigurationComposite {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Text resourceTypeText;
    private Label resourceTypeLabel;
    private IResourceTypeElement resourceTypeElement;

    private ResourceTypeElementConfigurationComposite() {
    }

    public static ResourceTypeElementConfigurationComposite create(TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory, Composite composite) {
        ResourceTypeElementConfigurationComposite resourceTypeElementConfigurationComposite = new ResourceTypeElementConfigurationComposite();
        resourceTypeElementConfigurationComposite.widgetFactory = tabbedPropertySheetWidgetFactory;
        resourceTypeElementConfigurationComposite.parent = composite;
        resourceTypeElementConfigurationComposite.create();
        return resourceTypeElementConfigurationComposite;
    }

    public void setResourceTypeElement(IResourceTypeElement iResourceTypeElement) {
        this.resourceTypeElement = iResourceTypeElement;
        if (iResourceTypeElement.getResourceType() > 0L) {
            this.resourceTypeText.setText(this.getResourceType(iResourceTypeElement.getResourceType()));
        }
    }

    private void create() {
        String string;
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.resourceTypeLabel = new Label(composite, 0);
        this.resourceTypeLabel.setText("Resource Type");
        this.resourceTypeLabel.setLayoutData((Object)this.createResourceTypeLabelLayoutData());
        this.resourceTypeLabel.setBackground(ColorConstants.white);
        this.resourceTypeLabel.pack();
        this.resourceTypeText = this.widgetFactory.createText(composite, "");
        this.resourceTypeText.setLayoutData((Object)this.createResourceTypeTextLayoutData());
        if (this.resourceTypeElement instanceof NodeDefinition && ((string = ((NodeDefinition)this.resourceTypeElement).getDefinitionName()) == null || string.trim().length() == 0)) {
            this.resourceTypeText.setEnabled(false);
        }
        this.resourceTypeText.setEnabled(false);
        this.resourceTypeText.pack();
    }

    private FormData createResourceTypeLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, -6);
        formData.top = new FormAttachment(0, 2);
        return formData;
    }

    private FormData createResourceTypeTextLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 79);
        formData.top = new FormAttachment(0, 0);
        formData.width = 180;
        return formData;
    }

    private String getResourceType(long l) {
        return ServiceFactory.createFactory().createResourceTypeService().getResourceType(l).getName();
    }
}

