/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import com.tandbergtv.watchpoint.studio.ui.properties.AbstractVariableTableItemWrapper;
import com.tandbergtv.watchpoint.studio.ui.properties.WPVariableTableCellClickedResolver;
import com.tandbergtv.watchpoint.studio.ui.properties.WPVariableTableItemWrapper;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.model.Variable;
import org.jbpm.gd.jpdl.model.VariableContainer;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public class WPVariableContainerConfigurationComposite
implements SelectionListener {
    private FormToolkit widgetFactory;
    private Composite parent;
    private Label messageLabel;
    private Table variablesTable;
    private Button addButton;
    private Button removeButton;
    private VariableContainer variableContainer;
    private WPVariableTableCellClickedResolver resolver;
    private String variableDefaultName = "variable";
    private boolean nameOnlyVisible = false;
    private String[] columnTitles = null;
    private AbstractPropertySection parentPropertySection;

    public static WPVariableContainerConfigurationComposite create(AbstractPropertySection abstractPropertySection, FormToolkit formToolkit, Composite composite, boolean bl, String[] stringArray) {
        WPVariableContainerConfigurationComposite wPVariableContainerConfigurationComposite = new WPVariableContainerConfigurationComposite();
        wPVariableContainerConfigurationComposite.parentPropertySection = abstractPropertySection;
        wPVariableContainerConfigurationComposite.widgetFactory = formToolkit;
        wPVariableContainerConfigurationComposite.parent = composite;
        wPVariableContainerConfigurationComposite.nameOnlyVisible = bl;
        wPVariableContainerConfigurationComposite.columnTitles = stringArray;
        wPVariableContainerConfigurationComposite.create();
        return wPVariableContainerConfigurationComposite;
    }

    public static WPVariableContainerConfigurationComposite create(AbstractPropertySection abstractPropertySection, FormToolkit formToolkit, Composite composite) {
        return WPVariableContainerConfigurationComposite.create(abstractPropertySection, formToolkit, composite, false, new String[]{"Display Name", "Process Variable", "Required", "Type", "Template Key", "Visible", "Reporting"});
    }

    private WPVariableContainerConfigurationComposite() {
    }

    public void setVariableContainer(VariableContainer variableContainer) {
        if (this.variableContainer == variableContainer) {
            return;
        }
        this.unhookListeners();
        this.variableContainer = variableContainer;
        this.clearControls();
        if (variableContainer != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.variablesTable.addSelectionListener((SelectionListener)this);
        this.variablesTable.addMouseListener((MouseListener)this.resolver);
    }

    private void unhookListeners() {
        this.addButton.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.variablesTable.removeSelectionListener((SelectionListener)this);
        this.variablesTable.removeMouseListener((MouseListener)this.resolver);
    }

    private void clearControls() {
        this.variablesTable.removeAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void updateControls() {
        this.addButton.setEnabled(true);
        this.refreshTable();
    }

    private void create() {
        this.messageLabel = this.widgetFactory.createLabel(this.parent, "Define the used variables :");
        this.variablesTable = this.widgetFactory.createTable(this.parent, 66304);
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.resolver = new WPVariableTableCellClickedResolver(this.variablesTable);
        this.removeButton.setEnabled(false);
        this.messageLabel.setLayoutData((Object)this.createMessageLabelLayoutData());
        this.variablesTable.setLayoutData((Object)this.createVariablesTableLayoutData());
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.initializeVariablesTable();
    }

    private void initializeVariablesTable() {
        this.variablesTable.setHeaderVisible(true);
        this.variablesTable.setLinesVisible(true);
        this.variablesTable.setLayout((Layout)new AutoResizeTableLayout(this.variablesTable));
        if (this.columnTitles.length == 7) {
            this.initializeStartTableColumns();
        } else {
            this.initializeTaskTableColumns();
        }
    }

    private void initializeStartTableColumns() {
        TableLayout tableLayout = (TableLayout)this.variablesTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn.setText("");
        ColumnWeightData columnWeightData = new ColumnWeightData(0);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.variablesTable, 16384);
        tableColumn2.setText(this.columnTitles[0]);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(15);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        TableColumn tableColumn3 = new TableColumn(this.variablesTable, 16384);
        tableColumn3.setText(this.columnTitles[1]);
        ColumnWeightData columnWeightData3 = new ColumnWeightData(15);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        if (this.nameOnlyVisible) {
            return;
        }
        TableColumn tableColumn4 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn4.setText(this.columnTitles[2]);
        ColumnWeightData columnWeightData4 = new ColumnWeightData(7);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData4);
        TableColumn tableColumn5 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn5.setText(this.columnTitles[3]);
        ColumnWeightData columnWeightData5 = new ColumnWeightData(10);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData5);
        TableColumn tableColumn6 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn6.setText(this.columnTitles[4]);
        ColumnWeightData columnWeightData6 = new ColumnWeightData(7);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData6);
        TableColumn tableColumn7 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn7.setText(this.columnTitles[5]);
        ColumnWeightData columnWeightData7 = new ColumnWeightData(7);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData7);
        TableColumn tableColumn8 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn8.setText(this.columnTitles[6]);
        ColumnWeightData columnWeightData8 = new ColumnWeightData(7);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData8);
    }

    private void initializeTaskTableColumns() {
        TableLayout tableLayout = (TableLayout)this.variablesTable.getLayout();
        TableColumn tableColumn = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn.setText("");
        ColumnWeightData columnWeightData = new ColumnWeightData(0);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        TableColumn tableColumn2 = new TableColumn(this.variablesTable, 16384);
        tableColumn2.setText(this.columnTitles[0]);
        ColumnWeightData columnWeightData2 = new ColumnWeightData(15);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData2);
        TableColumn tableColumn3 = new TableColumn(this.variablesTable, 16384);
        tableColumn3.setText(this.columnTitles[1]);
        ColumnWeightData columnWeightData3 = new ColumnWeightData(15);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData3);
        if (this.nameOnlyVisible) {
            return;
        }
        TableColumn tableColumn4 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn4.setText(this.columnTitles[2]);
        ColumnWeightData columnWeightData4 = new ColumnWeightData(7);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData4);
        TableColumn tableColumn5 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn5.setText(this.columnTitles[3]);
        ColumnWeightData columnWeightData5 = new ColumnWeightData(10);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData5);
        TableColumn tableColumn6 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn6.setText(this.columnTitles[4]);
        ColumnWeightData columnWeightData6 = new ColumnWeightData(7);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData6);
        TableColumn tableColumn7 = new TableColumn(this.variablesTable, 0x1000000);
        tableColumn7.setText(this.columnTitles[5]);
        ColumnWeightData columnWeightData7 = new ColumnWeightData(7);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData7);
    }

    private FormData createMessageLabelLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        return formData;
    }

    private FormData createVariablesTableLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.messageLabel, 5);
        formData.left = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        formData.right = new FormAttachment((Control)this.removeButton, -5);
        return formData;
    }

    private FormData createAddButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.variablesTable, 0);
        formData.top.alignment = 128;
        formData.left = new FormAttachment((Control)this.removeButton, 0);
        formData.left.alignment = 16384;
        formData.right = new FormAttachment(100, -5);
        return formData;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.addButton, 5);
        formData.right = new FormAttachment(100, -5);
        return formData;
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (selectionEvent.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        } else if (selectionEvent.widget == this.variablesTable) {
            this.handleVariablesTableSelected(selectionEvent);
        }
    }

    private void handleAddButtonSelected() {
        SemanticElementFactory semanticElementFactory = null;
        if (this.variableContainer instanceof SemanticElement) {
            semanticElementFactory = ((SemanticElement)this.variableContainer).getFactory();
        }
        Variable variable = this.createVariable(semanticElementFactory);
        variable.setMappedName(this.getNextAvailableVariableName());
        variable.setAccess("read,write");
        this.variableContainer.addVariable(variable);
        WPVariableTableItemWrapper wPVariableTableItemWrapper = new WPVariableTableItemWrapper(this.parentPropertySection, this.variablesTable, variable);
        this.variablesTable.setSelection(wPVariableTableItemWrapper.getTableItem());
        ((AbstractVariableTableItemWrapper)wPVariableTableItemWrapper).editCell(1);
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    private String getNextAvailableVariableName() {
        String string = this.variableDefaultName;
        int n = 1;
        while (this.hasTableVariableWithName(String.valueOf(string) + n)) {
            ++n;
        }
        return String.valueOf(string) + n;
    }

    private boolean hasTableVariableWithName(String string) {
        boolean bl = false;
        int n = this.variablesTable.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            AbstractVariableTableItemWrapper abstractVariableTableItemWrapper = (AbstractVariableTableItemWrapper)this.variablesTable.getItem(n2).getData();
            if (string.equals(abstractVariableTableItemWrapper.getVariable().getMappedName())) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    private void handleRemoveButtonSelected() {
        TableItem tableItem = this.variablesTable.getItem(this.variablesTable.getSelectionIndex());
        AbstractVariableTableItemWrapper abstractVariableTableItemWrapper = (AbstractVariableTableItemWrapper)tableItem.getData();
        this.variableContainer.removeVariable(abstractVariableTableItemWrapper.getVariable());
        this.refreshTable();
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    private void refreshTable() {
        this.variablesTable.removeAll();
        Variable[] variableArray = this.variableContainer.getVariables();
        if (variableArray != null) {
            int n = 0;
            while (n < variableArray.length) {
                WPVariableTableItemWrapper wPVariableTableItemWrapper = new WPVariableTableItemWrapper(this.parentPropertySection, this.variablesTable, variableArray[n]);
                this.variablesTable.setSelection(wPVariableTableItemWrapper.getTableItem());
                ((AbstractVariableTableItemWrapper)wPVariableTableItemWrapper).editCell(1);
                ++n;
            }
        }
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    private void handleVariablesTableSelected(SelectionEvent selectionEvent) {
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    public VariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    private Variable createVariable(SemanticElementFactory semanticElementFactory) {
        if (semanticElementFactory == null) {
            return new Variable();
        }
        return (Variable)semanticElementFactory.createById("org.jbpm.gd.jpdl.variable");
    }
}

