/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.properties.template;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Action;

public class ActionHandlerConfigurationComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Text handlerText;
    private Label handlerLabel;
    private ManualTaskNode manualTaskNode;

    private ActionHandlerConfigurationComposite() {
    }

    public static ActionHandlerConfigurationComposite create(TabbedPropertySheetWidgetFactory tabbedPropertySheetWidgetFactory, Composite composite) {
        ActionHandlerConfigurationComposite actionHandlerConfigurationComposite = new ActionHandlerConfigurationComposite();
        actionHandlerConfigurationComposite.widgetFactory = tabbedPropertySheetWidgetFactory;
        actionHandlerConfigurationComposite.parent = composite;
        actionHandlerConfigurationComposite.create();
        return actionHandlerConfigurationComposite;
    }

    public void setManualTaskNode(ManualTaskNode manualTaskNode) {
        if (this.manualTaskNode == manualTaskNode) {
            return;
        }
        this.clearControls();
        this.manualTaskNode = manualTaskNode;
        if (manualTaskNode != null) {
            if (this.manualTaskNode.getAction() == null) {
                this.manualTaskNode.setAction(this.createAction());
            }
            this.updateControls();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.widget == this.handlerText && this.manualTaskNode.getAction() != null) {
            this.manualTaskNode.getAction().setClassName(this.handlerText.getText());
        }
    }

    private void clearControls() {
        this.handlerText.setText("");
    }

    private void updateControls() {
        String string = this.manualTaskNode.getAction().getClassName();
        if (string != null && !string.equals("")) {
            this.handlerText.setText(string);
        } else {
            ApplicationProperties applicationProperties = ApplicationProperties.getInstance();
            String string2 = applicationProperties.getProperty("ManualTask.Handler");
            this.handlerText.setText(string2);
            this.manualTaskNode.getAction().setClassName(string2);
        }
    }

    private void create() {
        Composite composite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.handlerLabel = new Label(composite, 0);
        this.handlerLabel.setText("Action Handler");
        this.handlerLabel.setLayoutData((Object)this.createHandlerLabelLayoutData());
        this.handlerLabel.setBackground(ColorConstants.white);
        this.handlerLabel.pack();
        this.handlerText = this.widgetFactory.createText(this.parent, "");
        this.handlerText.setLayoutData((Object)this.createHandlerTextLayoutData());
        this.handlerText.addFocusListener((FocusListener)this);
        this.handlerText.pack();
    }

    private FormData createHandlerLabelLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        return formData;
    }

    private FormData createHandlerTextLayoutData() {
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 85);
        formData.top = new FormAttachment(1, 0);
        formData.right = new FormAttachment(100, 0);
        return formData;
    }

    private Action createAction() {
        return (Action)this.manualTaskNode.getFactory().createById("org.jbpm.gd.jpdl.action");
    }
}

