/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.util;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.service.ServiceErrorCode;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NodeDefinitionEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationErrorsView;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManager;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.common.xml.XmlAdapterFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Variable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utility {
    private static final Logger logger = Logger.getLogger(Utility.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String PLUGIN_ID = "org.jbpm.gd.jpdl";
    private static final String ICONS_PATH = "icons/";
    public static final String TEMPLATE_EDITOR_ID = "org.jbpm.gd.jpdl.editor";
    public static final String NODEDEF_EDITOR_ID = "com.tandbergtv.jpdl.nodedefinitioneditor";
    public static final String RESOURCE_TYPE_EDITOR_ID = "com.tandbergtv.watchpoint.studio.ui.editor.ResourceTypeEditor";
    public static final String TEMPLATE_EXPLORER_ID = "com.tandbergtv.gd.TemplateExplorer";
    public static final String NODEDEF_EXPLORER_ID = "com.tandbergtv.gd.NodeDefinitionExplorer";
    public static final String VALIDATION_ERRORS_ID = "com.tandbergtv.gd.ValidationErrors";
    private static IWorkbenchWindow window;

    private Utility() {
    }

    public static boolean closeEditor(String string, boolean bl) {
        if (window == null || window.getActivePage() == null) {
            return true;
        }
        IEditorPart iEditorPart = Utility.getEditor(string);
        if (iEditorPart == null) {
            return true;
        }
        return window.getActivePage().closeEditor(iEditorPart, bl);
    }

    public static IEditorPart getEditor(String string) {
        if (window == null || window.getActivePage() == null) {
            return null;
        }
        IEditorReference[] iEditorReferenceArray = window.getActivePage().getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference iEditorReference = iEditorReferenceArray[n2];
            IEditorPart iEditorPart = iEditorReference.getEditor(false);
            if (iEditorPart != null && iEditorPart.getEditorSite().getId().equals(string) && iEditorPart.getSite().getWorkbenchWindow().getActivePage() != null) {
                return iEditorPart;
            }
            ++n2;
        }
        return null;
    }

    public static NodeElementContainer getNodeElementContainer(IWorkbenchPart iWorkbenchPart) {
        SemanticElement semanticElement = null;
        if (iWorkbenchPart instanceof WatchPointTemplateEditor) {
            semanticElement = ((WatchPointTemplateEditor)iWorkbenchPart).getProcessDefinition();
        } else if (iWorkbenchPart instanceof NodeDefinitionEditor) {
            semanticElement = ((NodeDefinitionEditor)iWorkbenchPart).getNodeDefinition();
        }
        return semanticElement;
    }

    public static WorkflowTemplateDTO createTemplateDTO(long l, int n, String string, String string2, String string3) {
        WorkflowTemplateDTO workflowTemplateDTO = new WorkflowTemplateDTO();
        workflowTemplateDTO.setId(l);
        workflowTemplateDTO.setVersion(n);
        workflowTemplateDTO.setName(string);
        workflowTemplateDTO.setGpd(string3);
        workflowTemplateDTO.setXml(string2);
        return workflowTemplateDTO;
    }

    public static NodeDefinitionDTO createNodeDefinitionDTO(long l, String string, String string2, String string3) {
        NodeDefinitionDTO nodeDefinitionDTO = new NodeDefinitionDTO();
        nodeDefinitionDTO.setId(l);
        nodeDefinitionDTO.setName(string);
        nodeDefinitionDTO.setGpd(string3);
        nodeDefinitionDTO.setXml(string2);
        return nodeDefinitionDTO;
    }

    public static String getUserName() {
        String string = null;
        try {
            string = UserManager.getInstance().getCurrentUserId();
        }
        catch (UserManagementException userManagementException) {
            logger.error((Object)"Failed to get the current User Id.");
        }
        return string;
    }

    public static Document getDOMDocumentFromString(String string) {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
        }
        catch (SAXException sAXException) {
            throw new UIException("Could not parse DOM document.", sAXException);
        }
        catch (IOException iOException) {
            throw new UIException("Could not read from xml.", iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new UIException("Error in parser configuration.", parserConfigurationException);
        }
        return document;
    }

    public static String getXMLFromDocument(Document document) {
        StringWriter stringWriter = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document.getDocumentElement());
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new UIException("Could not transform DOM document.", transformerException);
        }
        return stringWriter.getBuffer().toString().replaceAll("&#13;", "");
    }

    public static boolean isOutgoingMessage(String string) {
        String string2 = ApplicationProperties.getInstance().get("WFS.ResourceType.SystemId").toString();
        return !string.substring(2, 4).equals(string2);
    }

    public static IWorkbenchWindow getWindow() {
        return window;
    }

    public static synchronized void setWindow(IWorkbenchWindow iWorkbenchWindow) {
        window = iWorkbenchWindow;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        try {
            URL uRL = Platform.getBundle((String)PLUGIN_ID).getEntry("/");
            URL uRL2 = new URL(uRL, ICONS_PATH + string);
            return ImageDescriptor.createFromURL((URL)uRL2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UIException("Could not open image at path icons/" + string, malformedURLException);
        }
    }

    public static void handleException(String string, Throwable throwable) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)string);
    }

    public static void updateValidationErrors(IWorkbenchPartSite iWorkbenchPartSite, List<ValidationMessage> list) {
        IWorkbenchPage iWorkbenchPage = iWorkbenchPartSite.getWorkbenchWindow().getActivePage();
        if (iWorkbenchPage != null) {
            IViewPart iViewPart = null;
            try {
                iViewPart = list != null && list.size() > 0 ? iWorkbenchPage.showView(VALIDATION_ERRORS_ID) : iWorkbenchPage.findView(VALIDATION_ERRORS_ID);
            }
            catch (PartInitException partInitException) {
                throw new UIException("Error opening validation errors view.", partInitException);
            }
            if (iViewPart instanceof ValidationErrorsView) {
                ((ValidationErrorsView)iViewPart).updateValidationMessages(list);
            }
        }
    }

    public static SemanticElement getContainedSemanticElement(Object object) {
        EditPart editPart;
        Object object2;
        SemanticElement semanticElement = null;
        if (object instanceof NotationElementGraphicalEditPart) {
            NotationElementGraphicalEditPart notationElementGraphicalEditPart = (NotationElementGraphicalEditPart)object;
            semanticElement = notationElementGraphicalEditPart.getNotationElement().getSemanticElement();
        } else if (object instanceof EditPart && (object2 = (editPart = (EditPart)object).getModel()) instanceof SemanticElement) {
            semanticElement = (SemanticElement)object2;
        }
        return semanticElement;
    }

    public static synchronized XmlAdapter getAdapterFromStream(String string, InputStream inputStream, SemanticElementFactory semanticElementFactory) {
        IStructuredModel iStructuredModel = null;
        try {
            XmlAdapter xmlAdapter;
            iStructuredModel = ModelManagerImpl.getInstance().getModelForRead("adapter", inputStream, null);
            IDOMModel iDOMModel = null;
            iDOMModel = (IDOMModel)iStructuredModel;
            XmlAdapterFactory xmlAdapterFactory = new XmlAdapterFactory((Document)iDOMModel.getDocument(), semanticElementFactory);
            XmlAdapter xmlAdapter2 = xmlAdapter = xmlAdapterFactory.adapt((Node)iDOMModel.getDocument().getDocumentElement());
            return xmlAdapter2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UIException("Invalid encoding in xml file " + string + ".", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new UIException("Could not read from xml file " + string + " to create model.", iOException);
        }
        finally {
            iStructuredModel.releaseFromRead();
        }
    }

    public static synchronized XmlAdapter getAdapterFromString(String string, SemanticElementFactory semanticElementFactory) {
        IStructuredModel iStructuredModel = null;
        try {
            XmlAdapter xmlAdapter;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
            iStructuredModel = ModelManagerImpl.getInstance().getModelForRead("adapter", (InputStream)byteArrayInputStream, null);
            IDOMModel iDOMModel = null;
            iDOMModel = (IDOMModel)iStructuredModel;
            XmlAdapterFactory xmlAdapterFactory = new XmlAdapterFactory((Document)iDOMModel.getDocument(), semanticElementFactory);
            XmlAdapter xmlAdapter2 = xmlAdapter = xmlAdapterFactory.adapt((Node)iDOMModel.getDocument().getDocumentElement());
            return xmlAdapter2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UIException("Invalid encoding in xml.", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new UIException("Could not read from xml to create model.", iOException);
        }
        finally {
            iStructuredModel.releaseFromRead();
        }
    }

    public static void reportError(String string, Exception exception) {
        String string2 = String.valueOf(string) + LINE_SEPARATOR + LINE_SEPARATOR + "Reason(s):" + LINE_SEPARATOR;
        if (exception instanceof ServiceValidationException) {
            List<ValidationMessage> list = ((ServiceValidationException)exception).getValidationMessages();
            if (list != null && !list.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (ValidationMessage validationMessage : list) {
                    try {
                        stringBuffer.append(ValidationMessages.getInstance().getMessage(validationMessage));
                        stringBuffer.append(LINE_SEPARATOR);
                    }
                    catch (Exception exception2) {
                        String string3 = "Could not read validation message " + validationMessage.getCode() + " from property file.";
                        stringBuffer.append(string3);
                        stringBuffer.append(LINE_SEPARATOR);
                    }
                }
                string2 = String.valueOf(string2) + stringBuffer.toString();
            } else {
                string2 = String.valueOf(string2) + exception.getMessage();
            }
        } else if (exception instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)exception;
            ServiceErrorCode serviceErrorCode = serviceException.getServiceErrorCode();
            string2 = ServiceErrors.getInstance().getProperty(serviceErrorCode.getCode());
        } else {
            string2 = String.valueOf(string2) + exception.getMessage();
        }
        logger.error((Object)("Failure in UI: " + string2), (Throwable)exception);
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)string2);
    }

    public static List<WPVariable> getVariables(NodeElementContainer nodeElementContainer) {
        ArrayList<WPVariable> arrayList;
        block4: {
            block3: {
                Variable[] variableArray;
                Task task;
                arrayList = new ArrayList<WPVariable>();
                if (!(nodeElementContainer instanceof WorkflowTemplate)) break block3;
                WorkflowTemplate workflowTemplate = (WorkflowTemplate)nodeElementContainer;
                StartState startState = workflowTemplate.getStartState();
                if (startState == null || (task = startState.getTask()) == null) break block4;
                Variable[] variableArray2 = variableArray = task.getController().getVariables();
                int n = variableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Variable variable = variableArray2[n2];
                    arrayList.add((WPVariable)variable);
                    ++n2;
                }
                break block4;
            }
            if (nodeElementContainer instanceof NodeDefinition) {
                NodeDefinition nodeDefinition = (NodeDefinition)nodeElementContainer;
                for (WPVariable wPVariable : nodeDefinition.getVariables()) {
                    WPVariable wPVariable2 = new WPVariable();
                    wPVariable2.setName(wPVariable.getMappedName());
                    arrayList.add(wPVariable2);
                }
            }
        }
        return arrayList;
    }

    public static IEditorPart getActiveEditor() {
        if (window == null || window.getActivePage() == null) {
            return null;
        }
        return window.getActivePage().getActiveEditor();
    }
}

