/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.ui.view.DTONameDecorator;
import com.tandbergtv.watchpoint.studio.ui.view.ValidationMessageGroup;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jbpm.gd.common.model.NamedElement;

public class ValidationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final String ERROR_IMAGE = "validation_error.png";
    private static final String WARNING_IMAGE = "validation_warning.png";
    private static final String NOTIFICATION_IMAGE = "validation_notification.png";
    private ImageRegistry imageRegistry = new ImageRegistry();

    public ValidationLabelProvider() {
        String string = ValidationMessageType.Error.name();
        this.imageRegistry.put(string, Utility.getImageDescriptor(ERROR_IMAGE));
        string = ValidationMessageType.Warning.name();
        this.imageRegistry.put(string, Utility.getImageDescriptor(WARNING_IMAGE));
        string = ValidationMessageType.Notification.name();
        this.imageRegistry.put(string, Utility.getImageDescriptor(NOTIFICATION_IMAGE));
    }

    public Image getColumnImage(Object object, int n) {
        if (n != 0 || !(object instanceof ValidationMessage)) {
            return null;
        }
        ValidationMessage validationMessage = (ValidationMessage)object;
        return this.getMessageImage(validationMessage.getType());
    }

    private Image getMessageImage(ValidationMessageType validationMessageType) {
        if (validationMessageType == null) {
            return null;
        }
        return this.imageRegistry.get(validationMessageType.name());
    }

    public String getColumnText(Object object, int n) {
        String string;
        block15: {
            block14: {
                string = "";
                if (!(object instanceof ValidationMessage)) break block14;
                ValidationMessage validationMessage = (ValidationMessage)object;
                switch (n) {
                    case 0: {
                        try {
                            string = ValidationMessages.getInstance().getMessage(validationMessage);
                            break;
                        }
                        catch (Exception exception) {
                            throw new UIException("Could not read validation message " + validationMessage.getCode() + " from property file.", exception);
                        }
                    }
                    case 1: {
                        if (validationMessage.getElement() instanceof NamedElement) {
                            string = ((NamedElement)validationMessage.getElement()).getName();
                            break;
                        }
                        if (validationMessage.getElement() instanceof IWatchPointDTO) {
                            string = new DTONameDecorator((IWatchPointDTO)validationMessage.getElement()).getName();
                            break;
                        }
                        break block15;
                    }
                    case 2: {
                        if (validationMessage.getElement() instanceof NamedElement) {
                            string = ((NamedElement)validationMessage.getElement()).getLabel();
                            break;
                        }
                        if (!(validationMessage.getElement() instanceof IWatchPointDTO)) break block15;
                        string = new DTONameDecorator((IWatchPointDTO)validationMessage.getElement()).getType();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block15;
            }
            if (object instanceof ValidationMessageGroup && n == 0) {
                ValidationMessageGroup validationMessageGroup = (ValidationMessageGroup)object;
                int n2 = validationMessageGroup.getMessages() != null ? validationMessageGroup.getMessages().size() : 0;
                string = String.valueOf(this.getDisplayText(validationMessageGroup.getMessageType())) + " (" + n2 + " items)";
            }
        }
        return string;
    }

    private String getDisplayText(ValidationMessageType validationMessageType) {
        String string = "Undefined";
        if (validationMessageType == null) {
            return string;
        }
        switch (validationMessageType) {
            case Error: {
                string = "Errors";
                break;
            }
            case Warning: {
                string = "Warnings";
                break;
            }
            case Notification: {
                string = "Notifications";
            }
        }
        return string;
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void dispose() {
        super.dispose();
        if (this.imageRegistry != null) {
            this.imageRegistry.dispose();
            this.imageRegistry = null;
        }
    }
}

