/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.nodedefinition;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class NodeDefinitionLabelProvider
extends LabelProvider
implements ILabelProvider {
    private static final String NODE_DEFINITION_IMAGE_PATH = "icon_node.png";
    private static final String RESOURCE_TYPE_IMAGE_PATH = "resource_type.png";
    private static final String LOCKED_IMAGE_PATH = "node_locked_else.png";
    private static final String LOCKEDBYME_IMAGE_PATH = "node_locked_self.png";

    public String getText(Object object) {
        String string = null;
        if (object instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)object;
            string = String.valueOf(resourceType.getName()) + " [" + resourceType.getSystemId() + "]";
        } else {
            string = object instanceof NodeDefinitionDTO ? ((NodeDefinitionDTO)object).getName() : super.getText(object);
        }
        return string;
    }

    public Image getImage(Object object) {
        Image image = null;
        String string = null;
        if (object instanceof ResourceType) {
            string = RESOURCE_TYPE_IMAGE_PATH;
            image = this.createImage(string);
        } else if (object instanceof NodeDefinitionDTO) {
            NodeDefinitionDTO nodeDefinitionDTO = (NodeDefinitionDTO)object;
            string = nodeDefinitionDTO.getLock() == null ? NODE_DEFINITION_IMAGE_PATH : (nodeDefinitionDTO.getLock().getOwnerId().equals(Utility.getUserName()) ? LOCKEDBYME_IMAGE_PATH : LOCKED_IMAGE_PATH);
            image = this.createImage(string);
        } else {
            image = super.getImage(object);
        }
        return image;
    }

    private Image createImage(String string) {
        if (string == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = Utility.getImageDescriptor(string);
        return new Image((Device)Display.getCurrent(), imageDescriptor.getImageData());
    }
}

