/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.view.template;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.ExportFailureException;
import com.tandbergtv.watchpoint.studio.lock.ILockable;
import com.tandbergtv.watchpoint.studio.service.IWorkflowTemplateService;
import com.tandbergtv.watchpoint.studio.service.LockFailureException;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.view.AbstractTreeViewExplorer;
import com.tandbergtv.watchpoint.studio.ui.view.DefaultContentProvider;
import com.tandbergtv.watchpoint.studio.ui.view.ViewAction;
import com.tandbergtv.watchpoint.studio.ui.view.template.TemplateLabelProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.AbstractWatchPointWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewWatchPointTemplateWizard;
import com.tandbergtv.watchpoint.studio.usermgmt.User;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManagementException;
import com.tandbergtv.watchpoint.studio.usermgmt.UserManager;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExplorer
extends AbstractTreeViewExplorer {
    private static final Logger logger = Logger.getLogger(TemplateExplorer.class);
    private Action copyAction;
    private Action publishAction;
    private Action unPublishAction;
    private Action exportAction;
    private IWorkflowTemplateService templateService = ServiceFactory.createFactory().createWorkflowTemplateService();

    @Override
    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)((TreeSelection)iSelection).getFirstElement();
        this.updateActions(workflowTemplateDTO);
    }

    @Override
    protected List<? extends IWatchPointDTO> getInput() {
        return this.templateService.getTemplateList();
    }

    @Override
    protected void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        iMenuManager.add((IAction)this.copyAction);
        iMenuManager.add((IAction)this.publishAction);
        iMenuManager.add((IAction)this.unPublishAction);
        iMenuManager.add((IAction)this.exportAction);
    }

    private void updateActions(WorkflowTemplateDTO workflowTemplateDTO) {
        boolean bl = workflowTemplateDTO != null;
        boolean bl2 = bl ? workflowTemplateDTO.isExportable() : false;
        this.editAction.setEnabled(bl && !bl2);
        this.publishAction.setEnabled(bl && !bl2);
        this.unPublishAction.setEnabled(bl && bl2);
        this.exportAction.setEnabled(bl && bl2);
        this.viewAction.setEnabled(bl);
        this.deleteAction.setEnabled(bl);
        this.copyAction.setEnabled(bl);
    }

    @Override
    protected void create() {
        if (!Utility.closeEditor("org.jbpm.gd.jpdl.editor", true)) {
            return;
        }
        this.openCreateWizard();
        this.refresh();
    }

    @Override
    protected void view() {
        ITreeSelection iTreeSelection = this.getSelection();
        this.openTemplate((ISelection)iTreeSelection, false);
    }

    @Override
    protected void edit() {
        ITreeSelection iTreeSelection = this.getSelection();
        this.openTemplate((ISelection)iTreeSelection, true);
        this.refresh();
        Utility.updateValidationErrors(this.getSite(), new ArrayList<ValidationMessage>());
    }

    @Override
    protected void delete() {
        boolean bl;
        ITreeSelection iTreeSelection = this.getSelection();
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)((TreeSelection)iTreeSelection).getFirstElement();
        if (workflowTemplateDTO == null) {
            return;
        }
        String string = "Are you sure you want to delete template '" + workflowTemplateDTO.getName() + "'?";
        WatchPointTemplateEditor watchPointTemplateEditor = (WatchPointTemplateEditor)Utility.getEditor("org.jbpm.gd.jpdl.editor");
        if (watchPointTemplateEditor != null && workflowTemplateDTO.getName().equals(watchPointTemplateEditor.getTemplateDTOName())) {
            string = String.valueOf(string) + " Any changes to the template will be lost.";
        }
        if (!(bl = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Confirm Delete", (String)string))) {
            return;
        }
        try {
            this.templateService.deleteTemplate(workflowTemplateDTO.getName(), Utility.getUserName());
        }
        catch (ServiceException serviceException) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
        if (watchPointTemplateEditor == null || workflowTemplateDTO.getName().equals(watchPointTemplateEditor.getTemplateDTOName())) {
            Utility.closeEditor("org.jbpm.gd.jpdl.editor", false);
        }
        this.refresh();
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new DefaultContentProvider();
    }

    @Override
    protected IBaseLabelProvider getLabelProvider() {
        return new TemplateLabelProvider();
    }

    @Override
    protected void createToolbar() {
        super.createToolbar();
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        iToolBarManager.add((IAction)this.copyAction);
        iToolBarManager.add((IAction)this.publishAction);
        iToolBarManager.add((IAction)this.unPublishAction);
        iToolBarManager.add((IAction)this.exportAction);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.copyAction = new ViewAction(this, "Copy"){

            public void performAction() {
                TemplateExplorer.this.copyTemplate();
            }
        };
        this.copyAction.setImageDescriptor(Utility.getImageDescriptor("copy.png"));
        this.publishAction = new ViewAction(this, "Publish"){

            public void performAction() {
                TemplateExplorer.this.publishTemplate();
            }
        };
        this.publishAction.setImageDescriptor(Utility.getImageDescriptor("publish.png"));
        this.unPublishAction = new ViewAction(this, "UnPublish"){

            public void performAction() {
                TemplateExplorer.this.unPublishTemplate();
            }
        };
        this.unPublishAction.setImageDescriptor(Utility.getImageDescriptor("unpublish.png"));
        this.exportAction = new ViewAction(this, "Export"){

            public void performAction() {
                TemplateExplorer.this.exportTemplate();
            }
        };
        this.exportAction.setImageDescriptor(Utility.getImageDescriptor("export.png"));
        this.updateActions(null);
    }

    private void refresh(WorkflowTemplateDTO workflowTemplateDTO) {
        this.updateActions(workflowTemplateDTO);
        this.refresh();
    }

    private void copyTemplate() {
        ITreeSelection iTreeSelection = this.getSelection();
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)((TreeSelection)iTreeSelection).getFirstElement();
        if (workflowTemplateDTO == null) {
            return;
        }
        IEditorPart iEditorPart = this.getTemplateEditor(workflowTemplateDTO);
        if (iEditorPart != null && (!this.getSite().getPage().saveEditor(iEditorPart, true) || iEditorPart.isDirty())) {
            return;
        }
        try {
            workflowTemplateDTO = this.templateService.getTemplateForView(workflowTemplateDTO.getName());
            IWorkbench iWorkbench = super.getSite().getWorkbenchWindow().getWorkbench();
            NewWatchPointTemplateWizard newWatchPointTemplateWizard = new NewWatchPointTemplateWizard();
            newWatchPointTemplateWizard.init(iWorkbench, (IStructuredSelection)new StructuredSelection(), workflowTemplateDTO);
            WizardDialog wizardDialog = new WizardDialog(iWorkbench.getActiveWorkbenchWindow().getShell(), (IWizard)newWatchPointTemplateWizard);
            wizardDialog.open();
        }
        catch (ServiceValidationException serviceValidationException) {
            Utility.updateValidationErrors(this.getSite(), serviceValidationException.getValidationMessages());
            throw new UIException("The template is invalid, can not save.", serviceValidationException);
        }
        catch (ServiceException serviceException) {
            throw new UIException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
        this.refresh();
    }

    private void publishTemplate() {
        ITreeSelection iTreeSelection = this.getSelection();
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)((TreeSelection)iTreeSelection).getFirstElement();
        if (workflowTemplateDTO == null) {
            return;
        }
        IEditorPart iEditorPart = this.getTemplateEditor(workflowTemplateDTO);
        if (iEditorPart != null && !this.getSite().getPage().saveEditor(iEditorPart, true)) {
            return;
        }
        try {
            String string = Utility.getUserName();
            String string2 = workflowTemplateDTO.getName();
            workflowTemplateDTO = this.templateService.publishTemplate(string2, string);
        }
        catch (ServiceValidationException serviceValidationException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Invalid Template", (String)"The template is invalid, can not publish.");
            Utility.updateValidationErrors(this.getSite(), serviceValidationException.getValidationMessages());
        }
        catch (ServiceException serviceException) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
        this.refresh(workflowTemplateDTO);
    }

    private void unPublishTemplate() {
        ITreeSelection iTreeSelection = this.getSelection();
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)((TreeSelection)iTreeSelection).getFirstElement();
        try {
            workflowTemplateDTO = this.templateService.unpublishTemplate(workflowTemplateDTO.getName());
        }
        catch (ServiceException serviceException) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
        this.refresh(workflowTemplateDTO);
    }

    private void exportTemplate() {
        ITreeSelection iTreeSelection = this.getSelection();
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)((TreeSelection)iTreeSelection).getFirstElement();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.getPathFromUser();
        if (string == null) {
            return;
        }
        hashMap.put("exportFilePath", string);
        try {
            workflowTemplateDTO = this.templateService.exportTemplate(workflowTemplateDTO.getName(), hashMap);
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Template Exported", (String)"Template was exported successfully.");
            this.refresh(workflowTemplateDTO);
        }
        catch (ExportFailureException exportFailureException) {
            Utility.handleException("Error exporting template.", exportFailureException);
            logger.error((Object)"Error exporting template.", (Throwable)exportFailureException);
        }
    }

    private void openTemplate(ISelection iSelection, boolean bl) {
        if (!Utility.closeEditor("org.jbpm.gd.jpdl.editor", true)) {
            return;
        }
        WorkflowTemplateDTO workflowTemplateDTO = (WorkflowTemplateDTO)((TreeSelection)iSelection).getFirstElement();
        WorkflowTemplateDTO workflowTemplateDTO2 = null;
        try {
            if (bl) {
                try {
                    workflowTemplateDTO2 = this.templateService.getTemplateForEdit(workflowTemplateDTO.getName(), Utility.getUserName(), false);
                }
                catch (LockFailureException lockFailureException) {
                    ILockable iLockable = lockFailureException.getLockableEntity();
                    String string = iLockable.getLock().getOwnerId();
                    String string2 = this.getUserDisplayMessage(string);
                    boolean bl2 = MessageDialog.openConfirm((Shell)super.getSite().getShell(), (String)"Override Lock?", (String)("The template " + workflowTemplateDTO.getName() + " is locked by " + string2 + ", do you wish to override the lock?"));
                    if (!bl2) {
                        return;
                    }
                    workflowTemplateDTO2 = this.templateService.getTemplateForEdit(workflowTemplateDTO.getName(), Utility.getUserName(), true);
                }
            } else {
                workflowTemplateDTO2 = this.templateService.getTemplateForView(workflowTemplateDTO.getName());
            }
            IFile iFile = TemplateResourcesUtility.createTemplateFile(workflowTemplateDTO2.getXml(), workflowTemplateDTO2.getGpd());
            try {
                IDE.openEditor((IWorkbenchPage)super.getSite().getWorkbenchWindow().getActivePage(), (IEditorInput)new NonPersistableFileEditorInput(iFile, workflowTemplateDTO2), (String)"org.jbpm.gd.jpdl.editor");
            }
            catch (PartInitException partInitException) {
                Utility.handleException("Error opening WatchPoint Template Editor.", partInitException);
            }
        }
        catch (ServiceException serviceException) {
            Utility.handleException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
    }

    private String getUserDisplayMessage(String string) {
        String string2 = null;
        try {
            User user = UserManager.getInstance().getUser(string);
            string2 = String.valueOf(user.getUserName()) + " from machine " + user.getIpAddress();
        }
        catch (UserManagementException userManagementException) {
            logger.error((Object)"Failed to get the User object.", (Throwable)userManagementException);
            string2 = string;
        }
        return string2;
    }

    private void openCreateWizard() {
        IWorkbench iWorkbench = super.getSite().getWorkbenchWindow().getWorkbench();
        NewWatchPointTemplateWizard newWatchPointTemplateWizard = new NewWatchPointTemplateWizard();
        ((AbstractWatchPointWizard)newWatchPointTemplateWizard).init(iWorkbench, (IStructuredSelection)new StructuredSelection());
        WizardDialog wizardDialog = new WizardDialog(iWorkbench.getActiveWorkbenchWindow().getShell(), (IWizard)newWatchPointTemplateWizard);
        wizardDialog.open();
    }

    private String getPathFromUser() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 131072);
        fileDialog.setText("Please select the file to export template to.");
        fileDialog.setFilterExtensions(new String[]{"*.xml"});
        String string = fileDialog.open();
        if (string != null && !string.endsWith(".xml")) {
            string = String.valueOf(string) + ".xml";
        }
        return string;
    }

    private IEditorPart getTemplateEditor(WorkflowTemplateDTO workflowTemplateDTO) {
        IEditorReference[] iEditorReferenceArray;
        WatchPointTemplateEditor watchPointTemplateEditor = null;
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        IEditorReference[] iEditorReferenceArray2 = iEditorReferenceArray = iWorkbenchPage.findEditors(null, "org.jbpm.gd.jpdl.editor", 2);
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            WatchPointTemplateEditor watchPointTemplateEditor2;
            WorkflowTemplateDTO workflowTemplateDTO2;
            IEditorReference iEditorReference = iEditorReferenceArray2[n2];
            IEditorPart iEditorPart = iEditorReference.getEditor(false);
            if (iEditorPart instanceof WatchPointTemplateEditor && (workflowTemplateDTO2 = (watchPointTemplateEditor2 = (WatchPointTemplateEditor)iEditorPart).getTemplateDTO()) != null && workflowTemplateDTO2.equals(workflowTemplateDTO)) {
                watchPointTemplateEditor = watchPointTemplateEditor2;
                break;
            }
            ++n2;
        }
        return watchPointTemplateEditor;
    }
}

