/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.service.ServiceException;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.service.ServiceValidationException;
import com.tandbergtv.watchpoint.studio.ui.TemplateResourcesUtility;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.ServiceErrors;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.wizard.AbstractWatchPointWizard;
import com.tandbergtv.watchpoint.studio.ui.wizard.NewNodeDefinitionWizardPage;
import com.tandbergtv.watchpoint.studio.ui.xml.NodeDefinitionDomAdapter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NewNodeDefinitionWizard
extends AbstractWatchPointWizard {
    private static final String INITIAL_GPD_XML = "initialGPD.xml";
    private static final String INITIAL_NODE_DEFINITION_XML = "initialNodeDefinition.xml";
    private static final String INITIAL_SUPERSTATE_NODE_DEFINITION_XML = "initialSuperStateNodeDefinition.xml";
    private static final String INITIAL_SINGLE_NODE_GPD_XML = "initialSingleNodeGPD.xml";
    private static final String AUTO_TASK_NODE_NAME = "//node[1]/@name";
    private NewNodeDefinitionWizardPage page;

    public NewNodeDefinitionWizard() {
        super("Node Definition");
        this.setWindowTitle("New WatchPoint Node Definition");
    }

    public void addPages() {
        this.page = new NewNodeDefinitionWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    protected boolean isNameDuplicate(String string) {
        return ServiceFactory.createFactory().createNodeDefinitionService().nameExists(string);
    }

    protected void closeEditor() {
        Utility.closeEditor("com.tandbergtv.jpdl.nodedefinitioneditor", true);
    }

    protected WizardPage getCurrentPage() {
        return this.page;
    }

    protected boolean setupEditor() {
        NodeDefinitionDTO nodeDefinitionDTO;
        if (Utility.getWindow() == null) {
            Utility.setWindow(this.getActiveWorkbenchWindow());
        }
        try {
            nodeDefinitionDTO = this.createInitialDTO();
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error initializing WatchPoint node definition editor.");
            return false;
        }
        nodeDefinitionDTO.setType(NodeDefinitionType.valueOf(this.page.getType()));
        nodeDefinitionDTO.setResourceType(this.page.getResourceType());
        this.saveNodeDefinition(nodeDefinitionDTO);
        IFile iFile = TemplateResourcesUtility.createNodeDefinitionFile(nodeDefinitionDTO.getXml(), nodeDefinitionDTO.getGpd());
        try {
            IDE.openEditor((IWorkbenchPage)this.getActivePage(), (IEditorInput)new NonPersistableFileEditorInput(iFile, nodeDefinitionDTO), (String)"com.tandbergtv.jpdl.nodedefinitioneditor");
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Error initializing WatchPoint node definition editor.");
            return false;
        }
        BasicNewResourceWizard.selectAndReveal((IResource)iFile, (IWorkbenchWindow)this.getActiveWorkbenchWindow());
        return true;
    }

    protected String getObjectName() {
        return this.page.getNodeDefinitionName();
    }

    private String createInitialNodeDefinition(String string, long l) {
        String string2 = NodeDefinitionType.valueOf(this.page.getType()) == NodeDefinitionType.SingleNode ? INITIAL_NODE_DEFINITION_XML : INITIAL_SUPERSTATE_NODE_DEFINITION_XML;
        SemanticElementFactory semanticElementFactory = new SemanticElementFactory("com.tandbergtv.jpdl.nodedefinitioneditor");
        NodeDefinition nodeDefinition = (NodeDefinition)semanticElementFactory.createById("com.tandbergtv.watchpoint.studio.nodeDefinition");
        NodeDefinitionDomAdapter nodeDefinitionDomAdapter = (NodeDefinitionDomAdapter)Utility.getAdapterFromStream(string2, ((Object)((Object)this)).getClass().getResourceAsStream(string2), semanticElementFactory);
        nodeDefinitionDomAdapter.initialize(nodeDefinition);
        nodeDefinition.setName(string);
        nodeDefinition.setResourceType(l);
        return Utility.getXMLFromDocument(nodeDefinitionDomAdapter.getNode().getOwnerDocument());
    }

    private String createInitialGpdInfo(String string) throws Exception {
        XPath xPath;
        XPathExpression xPathExpression;
        Node node;
        String string2 = NodeDefinitionType.valueOf(this.page.getType()) == NodeDefinitionType.SingleNode ? INITIAL_SINGLE_NODE_GPD_XML : INITIAL_GPD_XML;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(((Object)((Object)this)).getClass().getResourceAsStream(string2));
        if (NodeDefinitionType.valueOf(this.page.getType()) == NodeDefinitionType.SingleNode && (node = (Node)(xPathExpression = (xPath = XPathFactory.newInstance().newXPath()).compile(AUTO_TASK_NODE_NAME)).evaluate(document, XPathConstants.NODE)) != null) {
            node.setNodeValue(string);
        }
        return Utility.getXMLFromDocument(document);
    }

    private NodeDefinitionDTO createInitialDTO() throws Exception {
        return Utility.createNodeDefinitionDTO(-1L, this.getObjectName(), this.createInitialNodeDefinition(this.getObjectName(), this.page.getResourceType().getId()), this.createInitialGpdInfo(this.getObjectName()));
    }

    private void saveNodeDefinition(NodeDefinitionDTO nodeDefinitionDTO) {
        try {
            ServiceFactory.createFactory().createNodeDefinitionService().createNodeDefinition(nodeDefinitionDTO, Utility.getUserName(), true);
        }
        catch (ServiceValidationException serviceValidationException) {
            Utility.updateValidationErrors(this.getActivePage().getActivePart().getSite(), serviceValidationException.getValidationMessages());
            throw new UIException("The node definition is invalid, can not save.", serviceValidationException);
        }
        catch (ServiceException serviceException) {
            throw new UIException(ServiceErrors.getInstance().getProperty(serviceException.getServiceErrorCode().getCode()), serviceException);
        }
    }
}

