/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewWatchPointTemplateWizardPage
extends WizardPage {
    private Text processText;

    public NewWatchPointTemplateWizardPage(String string, String string2) {
        super("WatchPoint Template");
        this.setTitle(string);
        this.setDescription(string2);
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = this.createClientArea(composite);
        this.createLabel(composite2);
        this.createProcessField(composite2);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    public String getProcessName() {
        return this.processText.getText();
    }

    private Composite createClientArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    private void createLabel(Composite composite) {
        Label label = new Label(composite, 64);
        label.setText("Choose a template name.");
        GridData gridData = new GridData();
        gridData.widthHint = this.convertWidthInCharsToPixels(80);
        gridData.horizontalSpan = 3;
        label.setLayoutData((Object)gridData);
    }

    private void createProcessField(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Process name : ");
        this.processText = new Text(composite, 2048);
        this.processText.setTextLimit(50);
        this.processText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                this.checkNodeDefinitionName();
                NewWatchPointTemplateWizardPage.this.getContainer().updateButtons();
            }

            private void checkNodeDefinitionName() {
                String string = null;
                if (NewWatchPointTemplateWizardPage.this.processText.getText().equals("")) {
                    string = "Template name can not be empty.";
                } else if (NewWatchPointTemplateWizardPage.this.processText.getText().startsWith(" ") || NewWatchPointTemplateWizardPage.this.processText.getText().endsWith(" ")) {
                    string = "Template name is not valid. The Template name must not start or end with a blank.";
                }
                if (string != null) {
                    NewWatchPointTemplateWizardPage.this.setErrorMessage(string);
                } else {
                    NewWatchPointTemplateWizardPage.this.setErrorMessage(null);
                }
            }
        });
        GridData gridData = new GridData(768);
        this.processText.setLayoutData((Object)gridData);
    }
}

