/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceTypeWizardPage
extends WizardPage {
    private Text nameText;
    private Text systemIDText;
    private Text descText;
    private Combo connTypeCombo;
    private ModifyListener validationListener;
    private IResourceTypeService rtService;
    private Map<String, ConnectionType> connTypesNameObjMap = new HashMap<String, ConnectionType>();
    private boolean validationEnabled = false;

    public ResourceTypeWizardPage() {
        super("Resource Type");
        this.setTitle("Create Resource Type");
        this.setDescription("Create a new Resource Type");
        this.validationListener = new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceTypeWizardPage.this.validate();
            }
        };
        this.rtService = ServiceFactory.createFactory().createResourceTypeService();
    }

    public String getResourceTypeName() {
        return this.convertEmptyToNull(this.nameText.getText());
    }

    public String getResourceTypeSystemID() {
        return this.convertEmptyToNull(this.systemIDText.getText());
    }

    public String getResourceTypeDescription() {
        return this.convertEmptyToNull(this.descText.getText());
    }

    public ConnectionType getConnectionType() {
        return this.connTypesNameObjMap.get(this.connTypeCombo.getText());
    }

    public boolean isPageComplete() {
        return this.getErrorMessage() == null && this.nameText.getText().length() > 0;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = this.createClientArea(composite);
        this.createCustomControls(composite2);
        this.setValuesAndState();
        this.validationEnabled = true;
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private Composite createClientArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        composite2.setLayout((Layout)formLayout);
        return composite2;
    }

    private void createCustomControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Name : ");
        this.nameText = new Text(composite, 2048);
        this.nameText.setTextLimit(50);
        this.nameText.addModifyListener(this.validationListener);
        Label label2 = new Label(composite, 0);
        label2.setText("System ID : ");
        this.systemIDText = new Text(composite, 2048);
        this.systemIDText.setTextLimit(2);
        this.systemIDText.addModifyListener(this.validationListener);
        Label label3 = new Label(composite, 0);
        label3.setText("Description : ");
        this.descText = new Text(composite, 2818);
        this.descText.setTextLimit(256);
        this.descText.addModifyListener(this.validationListener);
        Label label4 = new Label(composite, 0);
        label4.setText("Connection Type : ");
        this.connTypeCombo = new Combo(composite, 780);
        this.connTypeCombo.addModifyListener(this.validationListener);
        FormData formData = new FormData();
        formData.left = new FormAttachment(30, 2);
        formData.right = new FormAttachment(100, -10);
        this.nameText.setLayoutData((Object)formData);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment((Control)this.nameText, 10);
        label2.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)this.nameText, 10);
        formData3.left = new FormAttachment(30, 2);
        formData3.right = new FormAttachment(100, -10);
        this.systemIDText.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.top = new FormAttachment((Control)this.systemIDText, 10);
        label3.setLayoutData((Object)formData4);
        FormData formData5 = new FormData();
        formData5.left = new FormAttachment(30, 2);
        formData5.top = new FormAttachment((Control)this.systemIDText, 10);
        formData5.right = new FormAttachment(100, -10);
        formData5.bottom = new FormAttachment((Control)this.connTypeCombo, -10);
        this.descText.setLayoutData((Object)formData5);
        FormData formData6 = new FormData();
        formData6.top = new FormAttachment((Control)this.descText, 10);
        label4.setLayoutData((Object)formData6);
        FormData formData7 = new FormData();
        formData7.left = new FormAttachment(30, 2);
        formData7.right = new FormAttachment(100, -10);
        formData7.bottom = new FormAttachment(100, -10);
        this.connTypeCombo.setLayoutData((Object)formData7);
    }

    private void setValuesAndState() {
        List<ConnectionType> list = this.rtService.getAllConnectionTypes();
        if (list != null && !list.isEmpty()) {
            for (ConnectionType connectionType : list) {
                this.connTypeCombo.add(connectionType.getName());
                this.connTypesNameObjMap.put(connectionType.getName(), connectionType);
            }
            this.connTypeCombo.select(0);
        }
    }

    private void validate() {
        if (!this.validationEnabled) {
            return;
        }
        String string = null;
        string = UIValidator.validateValue("Name", this.nameText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        string = UIValidator.validateValue("System ID", this.systemIDText.getText(), UIValidator.Validation.NOT_BLANK, UIValidator.Validation.TRIMMED, UIValidator.Validation.ALPHA_NUMERIC);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        string = UIValidator.validateValue("Description", this.descText.getText(), UIValidator.Validation.TRIMMED);
        if (string != null) {
            this.updateErrorMessage(string);
            return;
        }
        this.updateErrorMessage(null);
    }

    private void updateErrorMessage(String string) {
        this.setErrorMessage(string);
        this.getContainer().updateButtons();
    }

    private String convertEmptyToNull(String string) {
        return string.length() == 0 ? null : string;
    }
}

