/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.ui.wizard;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;

public class SelectFilesAndDirsPage
extends WizardPage {
    private static final String EMPTY_STRING = "";
    private String[] filterExtensions;
    private boolean dirsAllowed;
    private String labelText;
    private List listBox;

    public SelectFilesAndDirsPage(String string, boolean bl) {
        super(string);
        this.dirsAllowed = bl;
        this.setLabel(EMPTY_STRING);
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public void setLabel(String string) {
        this.labelText = string != null ? string : EMPTY_STRING;
    }

    public String getLabel() {
        return this.labelText;
    }

    public String[] getItems() {
        return this.listBox.getItems();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = this.createClientArea(composite);
        this.createFilesAndDirsControl(composite2);
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
    }

    private Composite createClientArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        composite2.setLayout((Layout)formLayout);
        return composite2;
    }

    private void createFilesAndDirsControl(Composite composite) {
        FormData formData;
        Label label = new Label(composite, 0);
        label.setText(this.labelText);
        this.listBox = new List(composite, 2818);
        Button button = new Button(composite, 8);
        button.setText("Add Files");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String[] stringArray = SelectFilesAndDirsPage.this.getFilePathsFromUser();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    SelectFilesAndDirsPage.this.listBox.add(string);
                    ++n2;
                }
            }
        });
        Button button2 = null;
        if (this.dirsAllowed) {
            button2 = new Button(composite, 8);
            button2.setText("Add Folder");
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    String string = SelectFilesAndDirsPage.this.getDirPathFormUser();
                    if (string != null && string.trim().length() > 0) {
                        SelectFilesAndDirsPage.this.listBox.add(string);
                    }
                }
            });
        }
        Button button3 = new Button(composite, 8);
        button3.setText("Remove");
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SelectFilesAndDirsPage.this.listBox.remove(SelectFilesAndDirsPage.this.listBox.getSelectionIndices());
            }
        });
        FormData formData2 = new FormData();
        formData2.left = new FormAttachment(0);
        label.setLayoutData((Object)formData2);
        FormData formData3 = new FormData();
        formData3.top = new FormAttachment((Control)label, 10);
        formData3.left = new FormAttachment(0);
        formData3.right = new FormAttachment(100, -10);
        formData3.bottom = new FormAttachment((Control)button, -10);
        this.listBox.setLayoutData((Object)formData3);
        FormData formData4 = new FormData();
        formData4.bottom = new FormAttachment(100);
        formData4.left = new FormAttachment(0);
        button.setLayoutData((Object)formData4);
        if (button2 != null) {
            formData = new FormData();
            formData.bottom = new FormAttachment(100);
            formData.left = new FormAttachment((Control)button, 5);
            button2.setLayoutData((Object)formData);
        }
        formData = new FormData();
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment((Control)(button2 != null ? button2 : button), 5);
        button3.setLayoutData((Object)formData);
    }

    private String[] getFilePathsFromUser() {
        FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 131074);
        fileDialog.setText("Select File(s)");
        if (this.filterExtensions != null) {
            fileDialog.setFilterExtensions(this.filterExtensions);
        }
        fileDialog.open();
        String[] stringArray = new String[fileDialog.getFileNames().length];
        int n = 0;
        String[] stringArray2 = fileDialog.getFileNames();
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            stringArray[n++] = String.valueOf(fileDialog.getFilterPath()) + File.separator + string;
            ++n3;
        }
        return stringArray;
    }

    private String getDirPathFormUser() {
        DirectoryDialog directoryDialog = new DirectoryDialog(Display.getCurrent().getActiveShell(), 131072);
        directoryDialog.setText("Select Folder");
        return directoryDialog.open();
    }
}

