/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.util.ValidationUtil;

public class ConvertExprUtility {
    private static String CLOSE_BRACKET = ")";
    private static final char ADD_OPERATOR = '+';
    private static final char MULTIPLY_OPERATOR = '*';

    public static String convertTimerExpression(String string) {
        String string2 = null;
        String[] stringArray = ValidationUtil.getOperands(string);
        int n = stringArray.length;
        switch (n) {
            case 1: {
                string2 = ConvertExprUtility.convertExpression(stringArray, ' ');
                break;
            }
            case 2: {
                char c = ValidationUtil.getOperator(string);
                string2 = ConvertExprUtility.convertExpression(stringArray, c);
                break;
            }
        }
        return string2;
    }

    private static String convertExpression(String[] stringArray, char c) {
        String string = null;
        string = c == '+' ? ConvertExprUtility.buildAddExpression(stringArray) : (c == '*' ? ConvertExprUtility.buildMlpyExpression(stringArray) : ConvertExprUtility.buildGeneralExpression(stringArray));
        return string;
    }

    public static String convertDecisionExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer("#{()}");
        stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), string);
        return stringBuffer.toString();
    }

    private static boolean isConstant(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > ':' || c < '0') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean isDurationConstant(String string) {
        return string.contains(":");
    }

    private static String buildAddExpression(String[] stringArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("util.addDates()");
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            StringBuffer stringBuffer2 = new StringBuffer("executionContext.getVariable().toString()");
            if (ConvertExprUtility.isDurationConstant(string)) {
                stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), "\"" + string + "\"");
            } else {
                stringBuffer2.insert(stringBuffer2.indexOf(CLOSE_BRACKET), "\"" + string + "\"");
                stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), stringBuffer2);
            }
            if (++n == 1) {
                stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), ",");
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String buildMlpyExpression(String[] stringArray) {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer("util.multiplyDate()");
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            StringBuffer stringBuffer2 = new StringBuffer("(Double.parseDouble(executionContext.getVariable().toString()))");
            StringBuffer stringBuffer3 = new StringBuffer("executionContext.getVariable().toString()");
            if (ConvertExprUtility.isConstant(string)) {
                if (ConvertExprUtility.isDurationConstant(string)) {
                    stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), "\"" + string + "\"");
                } else {
                    stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), string);
                }
            } else if (n != 0) {
                stringBuffer2.insert(stringBuffer2.indexOf(CLOSE_BRACKET), "\"" + string + "\"");
                stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), stringBuffer2);
            } else {
                stringBuffer3.insert(stringBuffer3.indexOf(CLOSE_BRACKET), "\"" + string + "\"");
                stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), stringBuffer3);
            }
            if (++n == 1) {
                stringBuffer.insert(stringBuffer.lastIndexOf(CLOSE_BRACKET), ",");
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    private static String buildGeneralExpression(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("executionContext.getVariable()");
        if (ConvertExprUtility.isDurationConstant(stringArray[0])) {
            return stringArray[0];
        }
        stringBuffer.insert(stringBuffer.indexOf(CLOSE_BRACKET), "\"" + stringArray[0] + "\"");
        return stringBuffer.toString();
    }
}

