/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.impl;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionClassConfiguration;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionConfigurationManager;
import com.tandbergtv.watchpoint.studio.ui.actionconfig.ActionVariableConfiguration;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.IDurationElement;
import com.tandbergtv.watchpoint.studio.ui.model.ManualTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.util.SemanticElementUtil;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.IValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.ValidationRuleInstantiationException;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceException;
import com.tandbergtv.watchpoint.studio.validation.ValidatorFactory;
import com.tandbergtv.watchpoint.studio.validation.graph.GraphFactory;
import com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph;
import com.tandbergtv.watchpoint.studio.validation.model.ActionVariable;
import com.tandbergtv.watchpoint.studio.validation.model.ConditionExpression;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerNode;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import com.tandbergtv.watchpoint.studio.validation.model.DecisionExpression;
import com.tandbergtv.watchpoint.studio.validation.model.DueDateExpression;
import com.tandbergtv.watchpoint.studio.validation.model.DurationExpression;
import com.tandbergtv.watchpoint.studio.validation.model.NodeDefinitionInstance;
import com.tandbergtv.watchpoint.studio.validation.model.SuperStateNodeDefinitionInstance;
import com.tandbergtv.watchpoint.studio.validation.model.TemplateNodeDefinitionInstance;
import com.tandbergtv.watchpoint.studio.validation.rules.actionvariable.ActionVariableValueRule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Fork;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationService
implements IValidationService {
    private static final Logger logger = Logger.getLogger(ValidationService.class);
    private static final String MODEL_ID = "ModelForValidation";
    private static final Lock MODEL_LOCK = new ReentrantLock();
    private ValidatorFactory validatorFactory = ValidatorFactory.createFactory();
    private GraphFactory graphFactory = GraphFactory.createFactory();

    @Override
    public List<ValidationMessage> validateTemplate(WorkflowTemplateDTO workflowTemplateDTO) {
        String string = workflowTemplateDTO.getXml();
        WorkflowTemplate workflowTemplate = this.createWorkflowTemplate(string);
        return this.validateTemplate(workflowTemplate);
    }

    @Override
    public List<ValidationMessage> validateTemplate(WorkflowTemplate workflowTemplate) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        List<ValidationMessage> list = null;
        list = this.validatorFactory.createValidator(WorkflowTemplate.class).validate((Class<WorkflowTemplate>)((Object)workflowTemplate));
        this.addMessages(arrayList, list);
        IWatchPointGraph iWatchPointGraph = this.graphFactory.createGraph(workflowTemplate);
        list = this.validatorFactory.createValidator(iWatchPointGraph).validate(iWatchPointGraph);
        this.addMessages(arrayList, list);
        NodeElement[] nodeElementArray = workflowTemplate.getNodeElements();
        if (nodeElementArray != null) {
            NodeElement[] nodeElementArray2 = nodeElementArray;
            int n = nodeElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                NodeElement nodeElement = nodeElementArray2[n2];
                this.validateTemplateNode(nodeElement, workflowTemplate, arrayList);
                ++n2;
            }
        }
        return arrayList;
    }

    @Override
    public List<ValidationMessage> validateNodeDefinition(NodeDefinition nodeDefinition) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        List<ValidationMessage> list = null;
        list = this.validatorFactory.createValidator(NodeDefinition.class).validate((Class<NodeDefinition>)((Object)nodeDefinition));
        this.addMessages(arrayList, list);
        this.validateDueDate(nodeDefinition, nodeDefinition, arrayList);
        this.validateDuration(nodeDefinition, nodeDefinition, arrayList);
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState) {
            IWatchPointGraph iWatchPointGraph = this.graphFactory.createGraph(nodeDefinition);
            list = this.validatorFactory.createValidator(iWatchPointGraph).validate(iWatchPointGraph);
            this.addMessages(arrayList, list);
            NodeElement[] nodeElementArray = nodeDefinition.getNodeElements();
            if (nodeElementArray != null) {
                NodeElement[] nodeElementArray2 = nodeElementArray;
                int n = nodeElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    NodeElement nodeElement = nodeElementArray2[n2];
                    this.validateSuperStateNode(nodeElement, nodeDefinition, arrayList);
                    ++n2;
                }
            }
        } else {
            nodeDefinition.getNodeType();
        }
        return arrayList;
    }

    @Override
    public List<ValidationMessage> validateResourceType(ResourceType resourceType) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        List<ValidationMessage> list = null;
        list = this.validatorFactory.createValidator(ResourceType.class).validate((Class<ResourceType>)((Object)resourceType));
        this.addMessages(arrayList, list);
        Set<Message> set = resourceType.getMessages();
        if (set != null) {
            for (Message message : set) {
                list = this.validateMessage(message);
                this.addMessages(arrayList, list);
            }
        }
        return arrayList;
    }

    @Override
    public List<ValidationMessage> validateMessage(Message message) {
        IValidator<Class<Message>> iValidator = this.validatorFactory.createValidator(Message.class);
        return iValidator.validate((Class<Message>)((Object)message));
    }

    @Override
    public List<ValidationMessage> validateResourceGroup(ResourceGroup resourceGroup) {
        return this.validatorFactory.createValidator(ResourceGroup.class).validate((Class<ResourceGroup>)((Object)resourceGroup));
    }

    @Override
    public List<ValidationMessage> validateDecisionExpression(Decision decision, WorkflowTemplate workflowTemplate) {
        List<ContainerVariable> list = this.getContainerVariables(workflowTemplate);
        DecisionExpression decisionExpression = new DecisionExpression(workflowTemplate, list, decision);
        return this.validatorFactory.createValidator(decisionExpression).validate(decisionExpression);
    }

    @Override
    public List<ValidationMessage> validateDecisionExpression(Decision decision, NodeDefinition nodeDefinition) {
        List<ContainerVariable> list = this.getContainerVariables(nodeDefinition);
        DecisionExpression decisionExpression = new DecisionExpression(nodeDefinition, list, decision);
        return this.validatorFactory.createValidator(decisionExpression).validate(decisionExpression);
    }

    private void validateDecisionExpression(Decision decision, NodeElementContainer nodeElementContainer, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            WorkflowTemplate workflowTemplate = (WorkflowTemplate)nodeElementContainer;
            list2 = this.validateDecisionExpression(decision, workflowTemplate);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)nodeElementContainer;
            list2 = this.validateDecisionExpression(decision, nodeDefinition);
        }
        this.addMessages(list, list2);
    }

    @Override
    public List<ValidationMessage> validateCondition(NodeElement nodeElement, Transition transition, WorkflowTemplate workflowTemplate) {
        List<ContainerVariable> list = this.getContainerVariables(workflowTemplate);
        ConditionExpression conditionExpression = new ConditionExpression(workflowTemplate, list, nodeElement, transition);
        return this.validatorFactory.createValidator(conditionExpression).validate(conditionExpression);
    }

    @Override
    public List<ValidationMessage> validateCondition(NodeElement nodeElement, Transition transition, NodeDefinition nodeDefinition) {
        List<ContainerVariable> list = this.getContainerVariables(nodeDefinition);
        ConditionExpression conditionExpression = new ConditionExpression(nodeDefinition, list, nodeElement, transition);
        return this.validatorFactory.createValidator(conditionExpression).validate(conditionExpression);
    }

    private void validateCondition(NodeElement nodeElement, Transition transition, NodeElementContainer nodeElementContainer, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            WorkflowTemplate workflowTemplate = (WorkflowTemplate)nodeElementContainer;
            list2 = this.validateCondition(nodeElement, transition, workflowTemplate);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)nodeElementContainer;
            list2 = this.validateCondition(nodeElement, transition, nodeDefinition);
        }
        this.addMessages(list, list2);
    }

    @Override
    public List<ValidationMessage> validateDueDate(IDueDateElement iDueDateElement, WorkflowTemplate workflowTemplate) {
        List<ContainerVariable> list = this.getContainerVariables(workflowTemplate);
        DueDateExpression dueDateExpression = new DueDateExpression(workflowTemplate, list, iDueDateElement);
        return this.validatorFactory.createValidator(dueDateExpression).validate(dueDateExpression);
    }

    @Override
    public List<ValidationMessage> validateDueDate(IDueDateElement iDueDateElement, NodeDefinition nodeDefinition) {
        DueDateExpression dueDateExpression = new DueDateExpression(nodeDefinition, null, iDueDateElement);
        return this.validatorFactory.createValidator(dueDateExpression).validate(dueDateExpression);
    }

    private void validateDueDate(IDueDateElement iDueDateElement, NodeElementContainer nodeElementContainer, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            WorkflowTemplate workflowTemplate = (WorkflowTemplate)nodeElementContainer;
            list2 = this.validateDueDate(iDueDateElement, workflowTemplate);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)nodeElementContainer;
            list2 = this.validateDueDate(iDueDateElement, nodeDefinition);
        }
        this.addMessages(list, list2);
    }

    @Override
    public List<ValidationMessage> validateDuration(IDurationElement iDurationElement, WorkflowTemplate workflowTemplate) {
        List<ContainerVariable> list = this.getContainerVariables(workflowTemplate);
        DurationExpression durationExpression = new DurationExpression(workflowTemplate, list, iDurationElement);
        return this.validatorFactory.createValidator(durationExpression).validate(durationExpression);
    }

    @Override
    public List<ValidationMessage> validateDuration(IDurationElement iDurationElement, NodeDefinition nodeDefinition) {
        DurationExpression durationExpression = new DurationExpression(nodeDefinition, null, iDurationElement);
        return this.validatorFactory.createValidator(durationExpression).validate(durationExpression);
    }

    private void validateDuration(IDurationElement iDurationElement, NodeElementContainer nodeElementContainer, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            WorkflowTemplate workflowTemplate = (WorkflowTemplate)nodeElementContainer;
            list2 = this.validateDuration(iDurationElement, workflowTemplate);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)nodeElementContainer;
            list2 = this.validateDuration(iDurationElement, nodeDefinition);
        }
        this.addMessages(list, list2);
    }

    @Override
    public List<ValidationMessage> validateActionVariableName(GenericElement genericElement) {
        ActionVariable actionVariable = new ActionVariable(genericElement);
        return this.validatorFactory.createValidator(actionVariable).validate(actionVariable);
    }

    @Override
    public List<ValidationMessage> validateActionVariableValue(AutomaticTaskNode automaticTaskNode, GenericElement genericElement) {
        Object object;
        Object object2;
        String string = automaticTaskNode != null && automaticTaskNode.getAction() != null ? automaticTaskNode.getAction().getClassName() : null;
        String string2 = genericElement.getName();
        ActionConfigurationManager actionConfigurationManager = ActionConfigurationManager.getInstance();
        ActionClassConfiguration actionClassConfiguration = actionConfigurationManager.getActionClass(string);
        Object object3 = null;
        if (actionClassConfiguration != null && (object2 = actionClassConfiguration.getVariables()) != null) {
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (ActionVariableConfiguration)iterator.next();
                if (!((ActionVariableConfiguration)object).getName().equals(string2)) continue;
                object3 = object;
                break;
            }
        }
        object2 = this.createActionVariableRule((ActionVariableConfiguration)object3);
        object = new ActionVariable(automaticTaskNode, genericElement, (ActionVariableConfiguration)object3);
        return ((ActionVariableValueRule)object2).validateRule((ActionVariable)object);
    }

    private ActionVariableValueRule createActionVariableRule(ActionVariableConfiguration actionVariableConfiguration) {
        String string;
        ActionVariableValueRule actionVariableValueRule = null;
        String string2 = string = actionVariableConfiguration != null ? actionVariableConfiguration.getValidationRuleClassName() : null;
        if (string != null && string.trim().length() > 0) {
            try {
                IValidationRule<?> iValidationRule = this.validatorFactory.createValidationRule(string);
                if (iValidationRule instanceof ActionVariableValueRule) {
                    actionVariableValueRule = (ActionVariableValueRule)iValidationRule;
                } else {
                    String string3 = "The Rule: " + string + " does not extend class: " + ActionVariableValueRule.class.getName() + ", cannot use specified rule for Action Variable validation" + ", using default implementation.";
                    logger.warn((Object)string3);
                }
            }
            catch (ValidationRuleInstantiationException validationRuleInstantiationException) {
                String string4 = "Failed to validate ActionVariableValueRule: " + string + ", using default implementation.";
                logger.warn((Object)string4, (Throwable)validationRuleInstantiationException);
            }
        }
        if (actionVariableValueRule == null) {
            actionVariableValueRule = new ActionVariableValueRule();
        }
        return actionVariableValueRule;
    }

    private void validateTemplateNode(NodeElement nodeElement, WorkflowTemplate workflowTemplate, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        list2 = this.validatorFactory.createValidator(NodeElement.class).validate((Class<NodeElement>)nodeElement);
        this.addMessages(list, list2);
        if (nodeElement instanceof StartState) {
            StartState startState = (StartState)nodeElement;
            list2 = this.validatorFactory.createValidator(StartState.class).validate((Class<StartState>)startState);
            this.addMessages(list, list2);
        } else if (nodeElement instanceof Decision) {
            this.validateDecision((Decision)nodeElement, (NodeElementContainer)workflowTemplate, list);
        } else if (nodeElement instanceof AutomaticTaskNode) {
            AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)nodeElement;
            this.validateAutomaticTaskNode(automaticTaskNode, (NodeElementContainer)workflowTemplate, list);
        } else if (nodeElement instanceof ManualTaskNode) {
            this.validateManualTaskNode((ManualTaskNode)nodeElement, (NodeElementContainer)workflowTemplate, list);
        } else if (nodeElement instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)nodeElement;
            TemplateNodeDefinitionInstance templateNodeDefinitionInstance = new TemplateNodeDefinitionInstance(nodeDefinition, workflowTemplate);
            this.validateNodeDefinitionInstance(templateNodeDefinitionInstance, list);
        } else if (nodeElement instanceof Fork) {
            Fork fork = (Fork)nodeElement;
            list2 = this.validatorFactory.createValidator(Fork.class).validate((Class<Fork>)fork);
            this.addMessages(list, list2);
        }
    }

    private void validateSuperStateNode(NodeElement nodeElement, NodeDefinition nodeDefinition, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        list2 = this.validatorFactory.createValidator(NodeElement.class).validate((Class<NodeElement>)nodeElement);
        this.addMessages(list, list2);
        if (nodeElement instanceof Decision) {
            this.validateDecision((Decision)nodeElement, nodeDefinition, list);
        } else if (nodeElement instanceof AutomaticTaskNode) {
            AutomaticTaskNode automaticTaskNode = (AutomaticTaskNode)nodeElement;
            this.validateAutomaticTaskNode(automaticTaskNode, nodeDefinition, list);
        } else if (nodeElement instanceof NodeDefinition) {
            NodeDefinition nodeDefinition2 = (NodeDefinition)nodeElement;
            SuperStateNodeDefinitionInstance superStateNodeDefinitionInstance = new SuperStateNodeDefinitionInstance(nodeDefinition2, nodeDefinition);
            this.validateNodeDefinitionInstance(superStateNodeDefinitionInstance, list);
        }
    }

    private void validateDecision(Decision decision, NodeElementContainer nodeElementContainer, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        list2 = this.validatorFactory.createValidator(Decision.class).validate((Class<Decision>)decision);
        this.addMessages(list, list2);
        this.validateDecisionExpression(decision, nodeElementContainer, list);
        Transition[] transitionArray = decision.getTransitions();
        if (transitionArray != null) {
            Transition[] transitionArray2 = transitionArray;
            int n = transitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray2[n2];
                this.validateCondition((NodeElement)decision, transition, nodeElementContainer, list);
                ++n2;
            }
        }
    }

    private void validateAutomaticTaskNode(AutomaticTaskNode automaticTaskNode, NodeElementContainer nodeElementContainer, List<ValidationMessage> list) {
        GenericElement[] genericElementArray;
        List<ValidationMessage> list2 = null;
        list2 = this.validatorFactory.createValidator(AutomaticTaskNode.class).validate((Class<AutomaticTaskNode>)((Object)automaticTaskNode));
        this.addMessages(list, list2);
        Action action = automaticTaskNode.getAction();
        GenericElement[] genericElementArray2 = genericElementArray = action != null ? action.getGenericElements() : null;
        if (genericElementArray != null) {
            GenericElement[] genericElementArray3 = genericElementArray;
            int n = genericElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement genericElement = genericElementArray3[n2];
                list2 = this.validateActionVariableValue(automaticTaskNode, genericElement);
                this.addMessages(list, list2);
                ++n2;
            }
        }
    }

    private void validateManualTaskNode(ManualTaskNode manualTaskNode, NodeElementContainer nodeElementContainer, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        list2 = this.validatorFactory.createValidator(ManualTaskNode.class).validate((Class<ManualTaskNode>)((Object)manualTaskNode));
        this.addMessages(list, list2);
        this.validateDueDate(manualTaskNode, nodeElementContainer, list);
        ContainerNode containerNode = this.createContainerNode(nodeElementContainer, (NodeElement)manualTaskNode);
        list2 = this.validatorFactory.createValidator(containerNode).validate(containerNode);
        this.addMessages(list, list2);
    }

    private void validateNodeDefinitionInstance(NodeDefinitionInstance nodeDefinitionInstance, List<ValidationMessage> list) {
        List<ValidationMessage> list2 = null;
        NodeDefinition nodeDefinition = nodeDefinitionInstance.getNodeInstance();
        String string = nodeDefinition.getDefinitionName();
        if (string == null || string.trim().length() == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_NODE_DEFINITION_TYPE_UNDEFINED;
            list.add(new ValidationMessage(nodeDefinition, ValidationMessageType.Error, validationMessageCode));
            return;
        }
        IValidator<Class<?>> iValidator = this.validatorFactory.createValidator(nodeDefinitionInstance.getClass());
        list2 = iValidator.validate((Class<?>)((Object)nodeDefinition));
        this.addMessages(list, list2);
        Object NEC = nodeDefinitionInstance.getContainer();
        this.validateDueDate(nodeDefinition, (NodeElementContainer)NEC, list);
        this.validateDuration(nodeDefinition, (NodeElementContainer)NEC, list);
        ContainerNode containerNode = this.createContainerNode((NodeElementContainer)nodeDefinitionInstance.getContainer(), (NodeElement)nodeDefinition);
        list2 = this.validatorFactory.createValidator(containerNode).validate(containerNode);
        this.addMessages(list, list2);
    }

    private List<ContainerVariable> getContainerVariables(WorkflowTemplate workflowTemplate) {
        Variable[] variableArray;
        Task task;
        ArrayList<ContainerVariable> arrayList = new ArrayList<ContainerVariable>();
        StartState startState = workflowTemplate.getStartState();
        Task task2 = task = startState != null ? startState.getTask() : null;
        if (task != null && task.getController() != null && (variableArray = task.getController().getVariables()) != null) {
            Variable[] variableArray2 = variableArray;
            int n = variableArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variable variable = variableArray2[n2];
                arrayList.add(new ContainerVariable(variable));
                ++n2;
            }
        }
        return arrayList;
    }

    private List<ContainerVariable> getContainerVariables(NodeDefinition nodeDefinition) {
        List<WPVariable> list;
        ArrayList<ContainerVariable> arrayList = new ArrayList<ContainerVariable>();
        if (nodeDefinition.getNodeType() == NodeDefinitionType.SuperState && (list = nodeDefinition.getVariables()) != null) {
            for (Variable variable : list) {
                arrayList.add(new ContainerVariable(variable, false));
            }
        }
        return arrayList;
    }

    private void addMessages(List<ValidationMessage> list, List<ValidationMessage> list2) {
        if (list2 != null) {
            list.addAll(list2);
        }
    }

    private WorkflowTemplate createWorkflowTemplate(String string) {
        MODEL_LOCK.lock();
        try {
            WorkflowTemplate workflowTemplate = SemanticElementUtil.createWorkflowTemplate(MODEL_ID, string);
            return workflowTemplate;
        }
        catch (Exception exception) {
            String string2 = "Failed to construct Semantic Element: WorkflowTemplate from the XML String.";
            throw new ValidationServiceException(string2, exception);
        }
        finally {
            MODEL_LOCK.unlock();
        }
    }

    private ContainerNode createContainerNode(NodeElementContainer nodeElementContainer, NodeElement nodeElement) {
        ContainerNode containerNode = null;
        if (nodeElementContainer instanceof WorkflowTemplate) {
            WorkflowTemplate workflowTemplate = (WorkflowTemplate)nodeElementContainer;
            List<ContainerVariable> list = this.getContainerVariables(workflowTemplate);
            containerNode = new ContainerNode(workflowTemplate, list, nodeElement);
        } else if (nodeElementContainer instanceof NodeDefinition) {
            NodeDefinition nodeDefinition = (NodeDefinition)nodeElementContainer;
            List<ContainerVariable> list = this.getContainerVariables(nodeDefinition);
            containerNode = new ContainerNode(nodeDefinition, list, nodeElement);
        }
        return containerNode;
    }
}

