/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.actionvariable;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.model.ActionVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionVariableNameRule
implements IValidationRule<ActionVariable> {
    private static final String VALID_TAG_NAME_REGEX = "[a-zA-Z]\\p{Alnum}*";
    private static final String PROP_RESTRICTED_VAR_NAMES = "AutoTask.Action.RestrictedVarNames";

    @Override
    public List<ValidationMessage> validateRule(ActionVariable actionVariable) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateBlankName(actionVariable, arrayList);
        this.validateNameValue(actionVariable, arrayList);
        return arrayList;
    }

    private void validateBlankName(ActionVariable actionVariable, List<ValidationMessage> list) {
        if (this.isBlank(actionVariable.getElement().getName())) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.ACTION_VARIABLE_NAME_BLANK;
            list.add(new ValidationMessage(actionVariable.getElement(), ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateNameValue(ActionVariable actionVariable, List<ValidationMessage> list) {
        ArrayList<String> arrayList;
        ValidationMessageCode validationMessageCode;
        if (this.isBlank(actionVariable.getElement().getName())) {
            return;
        }
        if (!Pattern.matches(VALID_TAG_NAME_REGEX, actionVariable.getElement().getName())) {
            validationMessageCode = ValidationMessageCode.ACTION_VARIABLE_NAME_INVALID;
            arrayList = new ArrayList<String>();
            arrayList.add(actionVariable.getElement().getName());
            list.add(new ValidationMessage(actionVariable.getElement(), ValidationMessageType.Error, validationMessageCode, arrayList));
        }
        if (this.restricted(actionVariable.getElement().getName())) {
            validationMessageCode = ValidationMessageCode.ACTION_VARIABLE_NAME_NOT_ALLOWED;
            arrayList = new ArrayList();
            arrayList.add(actionVariable.getElement().getName());
            list.add(new ValidationMessage(actionVariable.getElement(), ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }

    private boolean restricted(String string) {
        String string2 = ApplicationProperties.getInstance().getProperty(PROP_RESTRICTED_VAR_NAMES);
        if (string2 == null || string2.trim().length() == 0) {
            return false;
        }
        String[] stringArray = string2.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string3 = stringArray[n2];
            if (string.equalsIgnoreCase(string3.trim())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }
}

