/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTransitionNamesRule
implements IValidationRule<NodeElement> {
    @Override
    public List<ValidationMessage> validateRule(NodeElement nodeElement) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        Transition[] transitionArray = nodeElement.getTransitions();
        if (transitionArray != null) {
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            boolean bl = false;
            Transition[] transitionArray2 = transitionArray;
            int n = transitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray2[n2];
                String string = transition.getName();
                boolean bl2 = string == null || string.trim().length() == 0;
                bl |= bl2;
                if (!bl2) {
                    if (hashSet.contains(string = string.trim())) {
                        hashSet2.add(string);
                    } else {
                        hashSet.add(string);
                    }
                }
                ++n2;
            }
            this.validateBlankNames(nodeElement, bl, arrayList);
            this.validateDuplicateNames(nodeElement, hashSet2, arrayList);
        }
        return arrayList;
    }

    private void validateBlankNames(NodeElement nodeElement, boolean bl, List<ValidationMessage> list) {
        if (bl) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_TRANSITIONS_NO_LABEL;
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateDuplicateNames(NodeElement nodeElement, Set<String> set, List<ValidationMessage> list) {
        for (String string : set) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_TRANSITIONS_DUPLICATE_LABEL;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }
}

