/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTransitionsParallelRule
implements IValidationRule<NodeElement> {
    @Override
    public List<ValidationMessage> validateRule(NodeElement nodeElement) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Transition[] transitionArray = nodeElement.getTransitions();
        if (transitionArray != null) {
            Transition[] transitionArray2 = transitionArray;
            int n = transitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Transition transition = transitionArray2[n2];
                String string = transition.getTo();
                Integer n3 = (Integer)hashMap.get(string);
                int n4 = n3 != null ? n3 + 1 : 1;
                hashMap.put(string, n4);
                ++n2;
            }
        }
        this.validateParallelTransitions(nodeElement, hashMap, arrayList);
        return arrayList;
    }

    private void validateParallelTransitions(NodeElement nodeElement, Map<String, Integer> map, List<ValidationMessage> list) {
        ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_TRANSITIONS_PARALLEL;
        for (String string : map.keySet()) {
            Integer n = map.get(string);
            if (n <= 1) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            arrayList.add(n.toString());
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }
}

