/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerNode;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerVariable;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesMappingRule;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.IRequiredVariableFinder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.SuperStateRequiredVariableFinder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.TemplateRequiredVariableFinder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableContainerVariableMappingRule
extends NodeVariablesMappingRule {
    @Override
    protected List<Variable> getVariables(NodeElement nodeElement) {
        IWPVariableContainer iWPVariableContainer;
        List<WPVariable> list;
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        if (nodeElement instanceof IWPVariableContainer && (list = (iWPVariableContainer = (IWPVariableContainer)nodeElement).getVariables()) != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    @Override
    protected void validateMissingMapping(ContainerNode containerNode, Map<Variable, ContainerVariable> map, List<ValidationMessage> list) {
        NodeElement nodeElement = containerNode.getNode();
        if (nodeElement instanceof NodeDefinition) {
            Set<String> set = this.getRequiredVariableNames(containerNode);
            HashMap<Variable, ContainerVariable> hashMap = new HashMap<Variable, ContainerVariable>();
            for (Variable variable : map.keySet()) {
                if (set == null || !set.contains(variable.getMappedName())) continue;
                hashMap.put(variable, map.get(variable));
            }
            map = hashMap;
        }
        super.validateMissingMapping(containerNode, map, list);
    }

    private Set<String> getRequiredVariableNames(ContainerNode containerNode) {
        IRequiredVariableFinder iRequiredVariableFinder = null;
        Set<String> set = null;
        if (containerNode.getContainer() instanceof WorkflowTemplate) {
            iRequiredVariableFinder = new TemplateRequiredVariableFinder();
        } else if (containerNode.getContainer() instanceof NodeDefinition) {
            iRequiredVariableFinder = new SuperStateRequiredVariableFinder();
        }
        if (iRequiredVariableFinder != null) {
            set = iRequiredVariableFinder.getRequiredVariableNames((NodeDefinition)containerNode.getNode());
        }
        return set;
    }
}

