/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.automatictasknode;

import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionVariableRule
implements IValidationRule<AutomaticTaskNode> {
    @Override
    public List<ValidationMessage> validateRule(AutomaticTaskNode automaticTaskNode) {
        GenericElement[] genericElementArray;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        Action action = automaticTaskNode.getAction();
        if (action != null && (genericElementArray = action.getGenericElements()) != null) {
            boolean bl = false;
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            GenericElement[] genericElementArray2 = genericElementArray;
            int n = genericElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericElement genericElement = genericElementArray2[n2];
                String string = genericElement.getName();
                if (string != null) {
                    string = string.trim();
                }
                if (string == null || string.length() == 0) {
                    bl = true;
                } else if (!hashSet.contains(string)) {
                    hashSet.add(string);
                } else {
                    hashSet2.add(string);
                }
                ++n2;
            }
            this.validateBlankNames(automaticTaskNode, bl, arrayList);
            this.validateDuplicateNames(automaticTaskNode, hashSet2, arrayList);
        }
        return arrayList;
    }

    private void validateBlankNames(AutomaticTaskNode automaticTaskNode, boolean bl, List<ValidationMessage> list) {
        if (bl) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_ACTION_VARIABLES_BLANK_NAMES;
            list.add(new ValidationMessage(automaticTaskNode, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateDuplicateNames(AutomaticTaskNode automaticTaskNode, Set<String> set, List<ValidationMessage> list) {
        for (String string : set) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.NODE_ACTION_VARIABLES_DUPLICATE_NAMES;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            list.add(new ValidationMessage(automaticTaskNode, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }
}

