/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.resourcetype;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesPropertyRule
implements IValidationRule<ResourceType> {
    @Override
    public List<ValidationMessage> validateRule(ResourceType resourceType) {
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        this.validateMessages(resourceType, arrayList);
        return arrayList;
    }

    private void validateMessages(ResourceType resourceType, List<ValidationMessage> list) {
        Set<Message> set = resourceType.getMessages();
        if (set == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        for (Message message : set) {
            ResourceType resourceType2 = message.getResourceType();
            if (!resourceType.equals(resourceType2) && resourceType2 != null) {
                ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_RESOURCE_TYPE_INVALID;
                list.add(new ValidationMessage(message, ValidationMessageType.Error, validationMessageCode));
            }
            boolean bl = false;
            boolean bl2 = false;
            String string = message.getUid();
            String string2 = message.getName();
            if (message.isUIDGenerationRequired() || string == null || string.trim().length() == 0) {
                bl = true;
            }
            if (string2 == null || string2.trim().length() == 0) {
                bl2 = true;
            } else {
                string2 = string2.trim().toLowerCase();
            }
            if (!bl) {
                if (hashSet.contains(string)) {
                    hashSet2.add(string);
                } else {
                    hashSet.add(string);
                }
            }
            if (bl2) continue;
            if (hashSet3.contains(string2)) {
                hashSet4.add(message.getName());
                continue;
            }
            hashSet3.add(string2);
        }
        this.validateDuplicateUIDs(resourceType, hashSet2, list);
        this.validateDuplicateNames(resourceType, hashSet4, list);
    }

    private void validateDuplicateUIDs(ResourceType resourceType, Set<String> set, List<ValidationMessage> list) {
        for (String string : set) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_UID_DUPLICATES_ERROR;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }

    private void validateDuplicateNames(ResourceType resourceType, Set<String> set, List<ValidationMessage> list) {
        for (String string : set) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.RESOURCE_TYPE_MESSAGE_NAME_DUPLICATES_ERROR;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            list.add(new ValidationMessage(resourceType, ValidationMessageType.Error, validationMessageCode, arrayList));
        }
    }
}

