/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.template;

import com.tandbergtv.watchpoint.studio.service.IResourceGroupService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.IResourceGroupElement;
import com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.NodeElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtectionKeyMatchRule
implements IValidationRule<WorkflowTemplate> {
    @Override
    public List<ValidationMessage> validateRule(WorkflowTemplate workflowTemplate) {
        Object object;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        Set<ProtectionKey> set = workflowTemplate.getProtectionKeys();
        if (set == null) {
            set = new HashSet<ProtectionKey>();
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (ProtectionKey object22 : set) {
            object = object22.getName();
            if (object == null) {
                object = "";
            }
            if (hashSet.contains(object)) {
                if (hashSet2.contains(object)) continue;
                hashSet2.add(object);
                this.validateDuplicateProtectionKey((String)object, arrayList, workflowTemplate);
                continue;
            }
            hashSet.add((String)object);
        }
        ServiceFactory serviceFactory = ServiceFactory.createFactory();
        IResourceGroupService iResourceGroupService = serviceFactory.createResourceGroupService();
        object = new HashMap();
        Object object2 = workflowTemplate.getNodeElements();
        int string = ((NodeElement[])object2).length;
        int n = 0;
        while (n < string) {
            String string2;
            IResourceGroupElement iResourceGroupElement;
            ResourceGroup resourceGroup;
            Object object3 = object2[n];
            if (object3 instanceof IResourceGroupElement && (resourceGroup = (iResourceGroupElement = (IResourceGroupElement)object3).getResourceGroup()) != null && (string2 = resourceGroup.getName()) != null && string2.length() != 0) {
                HashSet<NodeElement> hashSet3 = (HashSet<NodeElement>)object.get(string2);
                if (hashSet3 == null) {
                    hashSet3 = new HashSet<NodeElement>();
                    object.put(string2, hashSet3);
                }
                hashSet3.add((NodeElement)object3);
            }
            ++n;
        }
        for (Object object3 : object.keySet()) {
            String string3 = iResourceGroupService.getProtectionKeyByResourceGroupName((String)object3).getName();
            object2 = (Set)object.get(object3);
            this.validateProtectionKeyForNodes(string3, hashSet, arrayList, (Set<NodeElement>)object2);
        }
        return arrayList;
    }

    private void validateDuplicateProtectionKey(String string, List<ValidationMessage> list, WorkflowTemplate workflowTemplate) {
        ValidationMessageCode validationMessageCode = ValidationMessageCode.DUPLICATE_TEMPLATE_PROTECTION_KEY;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        list.add(new ValidationMessage(workflowTemplate, ValidationMessageType.Error, validationMessageCode, arrayList));
    }

    private void validateProtectionKeyForNodes(String string, Set<String> set, List<ValidationMessage> list, Set<NodeElement> set2) {
        if (!set.contains(string)) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.TEMPLATE_NODE_PROTECTION_KEY_MISMATCH;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            for (NodeElement nodeElement : set2) {
                list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode, arrayList));
            }
        }
    }
}

