/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.template.graph;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequiredTemplateNodesRule
implements IValidationRule<WorkflowTemplateGraph> {
    @Override
    public List<ValidationMessage> validateRule(WorkflowTemplateGraph workflowTemplateGraph) {
        Object object2;
        ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        Set set = workflowTemplateGraph.getVertices();
        for (Object object2 : set) {
            NodeElement nodeElement = WatchPointGraphUtils.getWTVertexElement((Vertex)object2);
            if (nodeElement instanceof StartState) {
                ++n;
                continue;
            }
            if (nodeElement instanceof EndState) {
                ++n2;
                continue;
            }
            bl = true;
        }
        object2 = WatchPointGraphUtils.getElement((UserDataContainer)workflowTemplateGraph);
        this.validateStartNodeCount(n, arrayList, object2);
        this.validateEndNodeCount(n2, arrayList, object2);
        this.validateNodeCount(bl, arrayList, object2);
        return arrayList;
    }

    private void validateStartNodeCount(int n, List<ValidationMessage> list, Object object) {
        if (n == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.TEMPLATE_MISSING_START_NODE;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
        } else if (n > 1) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.TEMPLATE_EXTRA_START_NODE;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateEndNodeCount(int n, List<ValidationMessage> list, Object object) {
        if (n == 0) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.TEMPLATE_MISSING_END_NODE;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
        }
    }

    private void validateNodeCount(boolean bl, List<ValidationMessage> list, Object object) {
        if (!bl) {
            ValidationMessageCode validationMessageCode = ValidationMessageCode.TEMPLATE_MISSING_NODE;
            list.add(new ValidationMessage(object, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

