/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.validation.rules.template.graph;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;
import com.tandbergtv.watchpoint.studio.validation.graph.WatchPointGraphUtils;
import com.tandbergtv.watchpoint.studio.validation.graph.WorkflowTemplateGraph;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.NodeReachableRule;
import edu.uci.ics.jung.graph.Vertex;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.StartState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateNodeReachableRule
extends NodeReachableRule<WorkflowTemplateGraph> {
    @Override
    protected Set<Vertex> getRootVertices(WorkflowTemplateGraph workflowTemplateGraph) {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        for (Object e : workflowTemplateGraph.getVertices()) {
            Vertex vertex = (Vertex)e;
            NodeElement nodeElement = WatchPointGraphUtils.getWTVertexElement(vertex);
            if (!(nodeElement instanceof StartState)) continue;
            hashSet.add(vertex);
        }
        return hashSet;
    }

    @Override
    protected Set<Vertex> getSinkVertices(WorkflowTemplateGraph workflowTemplateGraph) {
        HashSet<Vertex> hashSet = new HashSet<Vertex>();
        for (Object e : workflowTemplateGraph.getVertices()) {
            Vertex vertex = (Vertex)e;
            NodeElement nodeElement = WatchPointGraphUtils.getWTVertexElement(vertex);
            if (!(nodeElement instanceof EndState)) continue;
            hashSet.add(vertex);
        }
        return hashSet;
    }

    @Override
    protected void validateNodesUnreachableFromRoot(Set<Vertex> set, List<ValidationMessage> list) {
        this.validateUnreachableNode(set, list, true);
    }

    @Override
    protected void validateNodesUnreachableToSink(Set<Vertex> set, List<ValidationMessage> list) {
        this.validateUnreachableNode(set, list, false);
    }

    private void validateUnreachableNode(Set<Vertex> set, List<ValidationMessage> list, boolean bl) {
        if (set == null) {
            return;
        }
        for (Vertex vertex : set) {
            NodeElement nodeElement = WatchPointGraphUtils.getWTVertexElement(vertex);
            ValidationMessageCode validationMessageCode = bl ? ValidationMessageCode.NODE_UNREACHABLE_FROM_START : ValidationMessageCode.NODE_UNREACHABLE_TO_END;
            list.add(new ValidationMessage(nodeElement, ValidationMessageType.Error, validationMessageCode));
        }
    }
}

