/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.exceptions.ConstraintViolationException;
import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.event.GraphEventListener;
import edu.uci.ics.jung.graph.event.GraphEventType;
import edu.uci.ics.jung.graph.event.GraphListenerHandler;
import edu.uci.ics.jung.graph.predicates.GPredicate;
import edu.uci.ics.jung.graph.predicates.NotInGraphEdgePredicate;
import edu.uci.ics.jung.graph.predicates.NotInGraphVertexPredicate;
import edu.uci.ics.jung.utils.UserDataDelegate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;

public abstract class AbstractArchetypeGraph
extends UserDataDelegate
implements ArchetypeGraph,
Cloneable {
    protected GraphListenerHandler mGraphListenerHandler;
    protected Map mVertexIDs;
    protected Map mEdgeIDs;
    protected Requirements edge_requirements;
    protected Requirements vertex_requirements;

    protected void initialize() {
        this.mGraphListenerHandler = new GraphListenerHandler(this);
        this.mVertexIDs = new HashMap();
        this.mEdgeIDs = new HashMap();
        this.edge_requirements = new Requirements();
        this.vertex_requirements = new Requirements();
        NotInGraphEdgePredicate ep = new NotInGraphEdgePredicate(this);
        this.edge_requirements.add(ep);
        ep.isInitializationPredicate = true;
        NotInGraphVertexPredicate vp = new NotInGraphVertexPredicate(this);
        this.vertex_requirements.add(vp);
        vp.isInitializationPredicate = true;
    }

    public ArchetypeGraph newInstance() {
        try {
            AbstractArchetypeGraph aag = (AbstractArchetypeGraph)this.clone();
            aag.initialize();
            this.addAllNotInitializers(aag.getEdgeConstraints(), this.getEdgeConstraints());
            this.addAllNotInitializers(aag.getVertexConstraints(), this.getVertexConstraints());
            return aag;
        }
        catch (CloneNotSupportedException e) {
            throw new FatalException("Failed attempt to clone graph", e);
        }
    }

    protected void addAllNotInitializers(Collection targetPredicates, Collection sourcePredicates) {
        Iterator iter = sourcePredicates.iterator();
        while (iter.hasNext()) {
            Predicate p = (Predicate)iter.next();
            if (p instanceof GPredicate) {
                GPredicate gp = (GPredicate)p;
                if (gp.isInitializationPredicate) continue;
            }
            targetPredicates.add(p);
        }
    }

    ArchetypeVertex getVertexByID(int id) {
        return (ArchetypeVertex)this.mVertexIDs.get(new Integer(id));
    }

    ArchetypeEdge getEdgeByID(int id) {
        return (ArchetypeEdge)this.mEdgeIDs.get(new Integer(id));
    }

    public String toString() {
        return "G" + this.hashCode() + this.getVertices();
    }

    public int numVertices() {
        return this.getVertices().size();
    }

    public int numEdges() {
        return this.getEdges().size();
    }

    public Collection getVertexConstraints() {
        return this.vertex_requirements;
    }

    public Collection getEdgeConstraints() {
        return this.edge_requirements;
    }

    public void addListener(GraphEventListener gel, GraphEventType get) {
        this.mGraphListenerHandler.addListener(gel, get);
    }

    public void removeListener(GraphEventListener gel, GraphEventType get) {
        this.mGraphListenerHandler.removeListener(gel, get);
    }

    protected boolean listenersExist(GraphEventType type) {
        return this.mGraphListenerHandler.listenersExist(type);
    }

    public ArchetypeGraph copy() {
        ArchetypeGraph c = this.newInstance();
        Iterator iter = this.getVertices().iterator();
        while (iter.hasNext()) {
            ArchetypeVertex av = (ArchetypeVertex)iter.next();
            av.copy(c);
        }
        iter = this.getEdges().iterator();
        while (iter.hasNext()) {
            ArchetypeEdge ae = (ArchetypeEdge)iter.next();
            ae.copy(c);
        }
        c.importUserData(this);
        return c;
    }

    protected void checkConstraints(Object o, Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            Predicate p = (Predicate)iter.next();
            if (p.evaluate(o)) continue;
            throw new ConstraintViolationException("Predicate " + p.getClass().getName() + " rejected " + o + ": " + p, p);
        }
    }

    public void removeAllVertices() {
        this.removeVertices(this.getVertices());
    }

    public void removeAllEdges() {
        this.removeEdges(this.getEdges());
    }

    protected class Requirements
    extends LinkedList {
        protected Requirements() {
        }

        public boolean add(Object o) {
            Set edges = AbstractArchetypeGraph.this.getEdges();
            Set vertices = AbstractArchetypeGraph.this.getVertices();
            if (!this.contains(o)) {
                if (edges != null && !edges.isEmpty() || vertices != null && !vertices.isEmpty()) {
                    throw new IllegalArgumentException("Cannot add requirements to a non-empty graph");
                }
                super.add((Predicate)o);
                return true;
            }
            return false;
        }

        public boolean evaluate(Object o) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                Predicate p = (Predicate)iter.next();
                if (p.evaluate(o)) continue;
                return false;
            }
            return true;
        }
    }
}

