/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.utils.Pair;
import samples.preview_new_graphdraw.CoordinateUtil;
import samples.preview_new_graphdraw.Coordinates;
import samples.preview_new_graphdraw.VisVertex;

public class VisEdge {
    protected Edge mEdge;
    protected VisVertex mFront;
    protected VisVertex mBack;

    public VisEdge(Edge e, VisVertex v1, VisVertex v2) {
        this.mEdge = e;
        this.mFront = v1;
        this.mBack = v2;
        Pair p = e.getEndpoints();
        if (p.getFirst() == v2) {
            this.mFront = v2;
            this.mBack = v1;
        }
    }

    public double getSquareDistance(double x, double y) {
        VisVertex c1 = this.mFront;
        VisVertex c2 = this.mBack;
        return CoordinateUtil.squareDistanceLineToPoint(c1, c2, x, y);
    }

    public Edge getEdge() {
        return this.mEdge;
    }

    public Coordinates getFront() {
        return this.mFront;
    }

    public Coordinates getBack() {
        return this.mBack;
    }

    public VisEdge copy(VisVertex front, VisVertex back) {
        return new VisEdge(this.getEdge(), front, back);
    }
}

