/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.prefs;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jbpm.gd.jpdl.Constants;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.util.AssignmentTypeHelper;
import org.jbpm.gd.jpdl.util.AutoResizeTableLayout;

public class AssignmentTypesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
Constants {
    Table assignmentTypesTable;

    public AssignmentTypesPage() {
        this.setPreferenceStore(Plugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite clientArea = this.createClientArea(parent);
        this.createAssignmentTypesTable(clientArea);
        return null;
    }

    private void createAssignmentTypesTable(Composite parent) {
        this.assignmentTypesTable = new Table(parent, 2592);
        this.assignmentTypesTable.setLinesVisible(true);
        this.assignmentTypesTable.setHeaderVisible(true);
        AutoResizeTableLayout layout = new AutoResizeTableLayout(this.assignmentTypesTable);
        TableColumn labelColumn = new TableColumn(this.assignmentTypesTable, 16384);
        labelColumn.setText("Label");
        ColumnWeightData labelColumnData = new ColumnWeightData(30);
        layout.addColumnData((ColumnLayoutData)labelColumnData);
        TableColumn idColumn = new TableColumn(this.assignmentTypesTable, 16384);
        idColumn.setText("Id");
        ColumnWeightData idColumnData = new ColumnWeightData(30);
        layout.addColumnData((ColumnLayoutData)idColumnData);
        TableColumn targetClassColumn = new TableColumn(this.assignmentTypesTable, 16384);
        targetClassColumn.setText("Target Class");
        ColumnWeightData targetClassColumnData = new ColumnWeightData(30);
        layout.addColumnData((ColumnLayoutData)targetClassColumnData);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.assignmentTypesTable.setLayoutData((Object)gridData);
        Map assignmentTypeMap = AssignmentTypeHelper.getLabelMap();
        for (String label : assignmentTypeMap.keySet()) {
            for (IConfigurationElement element : (Set)assignmentTypeMap.get(label)) {
                TableItem item = new TableItem(this.assignmentTypesTable, 0);
                item.setData((Object)element);
                item.setText(0, label);
                item.setText(1, element.getAttribute("id"));
                item.setText(2, element.getAttribute("input"));
                boolean disabled = this.getPreferenceStore().getBoolean(this.getPreferencesKey(element));
                item.setChecked(!disabled);
            }
        }
    }

    private String getPreferencesKey(IConfigurationElement element) {
        return "assignmentType(" + element.getAttribute("id") + ").disabled";
    }

    private Composite createClientArea(Composite parent) {
        Composite clientArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        clientArea.setLayoutData((Object)gridData);
        return clientArea;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        TableItem[] items = this.assignmentTypesTable.getItems();
        int i = 0;
        while (i < items.length) {
            this.getPreferenceStore().setValue(this.getPreferencesKey((IConfigurationElement)items[i].getData()), !items[i].getChecked());
            ++i;
        }
        return true;
    }

    public void performDefaults() {
        TableItem[] items = this.assignmentTypesTable.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setChecked(true);
            this.getPreferenceStore().setValue(this.getPreferencesKey((IConfigurationElement)items[i].getData()), !items[i].getChecked());
            ++i;
        }
    }
}

