/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.util.BooleanTypeHelper;

public class ScriptAdvancedConfigurationComposite
implements SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Button acceptPropagatedEventsButton;
    private Script script;

    public static ScriptAdvancedConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ScriptAdvancedConfigurationComposite result = new ScriptAdvancedConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private ScriptAdvancedConfigurationComposite() {
    }

    public void setScript(Script script) {
        if (this.script == script) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.script = script;
        if (script != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.acceptPropagatedEventsButton.addSelectionListener((SelectionListener)this);
    }

    private void unhookSelectionListener() {
        this.acceptPropagatedEventsButton.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.acceptPropagatedEventsButton.setSelection(false);
    }

    private void updateControls() {
        this.acceptPropagatedEventsButton.setSelection(BooleanTypeHelper.booleanValue(this.script.getAcceptPropagatedEvents()));
    }

    private void create() {
        this.acceptPropagatedEventsButton = this.widgetFactory.createButton(this.parent, "Accept Propagated Events", 32);
        this.acceptPropagatedEventsButton.setLayoutData((Object)this.createAcceptPropagatedEventsButtonLayoutData());
    }

    private FormData createAcceptPropagatedEventsButtonLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.acceptPropagatedEventsButton) {
            this.script.setAcceptPropagatedEvents(this.acceptPropagatedEventsButton.getSelection() ? "true" : "false");
        }
    }
}

