/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.Swimlane;
import org.jbpm.gd.jpdl.properties.SwimlaneConfigurationComposite;
import org.jbpm.gd.jpdl.properties.SwimlaneContainerSectionActionBarContributor;

public class SwimlaneContainerSection
extends AbstractPropertySection
implements PropertyChangeListener,
SelectionListener,
FocusListener {
    private Composite detailsArea;
    private Table swimlaneTable;
    private ProcessDefinition processDefinition;
    private Swimlane selectedSwimlane;
    private SwimlaneConfigurationComposite swimlaneConfigurationComposite;
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private SwimlaneContainerSectionActionBarContributor actionBarContributor;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.actionBarContributor = new SwimlaneContainerSectionActionBarContributor(this);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createMasterArea(composite);
        this.createDetailsArea(composite);
    }

    public TabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.tabbedPropertySheetPage;
    }

    private void createMasterArea(Composite composite) {
        this.swimlaneTable = this.getWidgetFactory().createTable(composite, 68356);
        this.swimlaneTable.setLayoutData((Object)this.createSwimlaneListLayoutData());
        this.swimlaneTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwimlaneContainerSection.this.handleSwimlaneListSelection();
            }
        });
        this.actionBarContributor.createPopupMenu((Composite)this.swimlaneTable);
    }

    private void handleSwimlaneListSelection() {
        if (this.processDefinition == null) {
            return;
        }
        int i = this.swimlaneTable.getSelectionIndex();
        if (i == -1) {
            this.setSelectedSwimlane(null);
        } else {
            this.setSelectedSwimlane((Swimlane)this.swimlaneTable.getSelection()[0].getData());
        }
    }

    private FormData createSwimlaneListLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private void createDetailsArea(Composite composite) {
        this.detailsArea = this.getWidgetFactory().createComposite(composite);
        this.detailsArea.setLayout((Layout)new FormLayout());
        this.detailsArea.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.createSwimlaneConfigurationComposite();
    }

    private void createSwimlaneConfigurationComposite() {
        this.swimlaneConfigurationComposite = SwimlaneConfigurationComposite.create(this.getWidgetFactory(), this.detailsArea);
    }

    private FormData createDetailsAreaLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.swimlaneTable, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void aboutToBeShown() {
        this.actionBarContributor.activateContributions();
    }

    public void aboutToBeHidden() {
        this.actionBarContributor.deactivateContributions();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            this.setProcessDefinition((ProcessDefinition)notationElement.getSemanticElement());
        } else if (input instanceof OutlineEditPart) {
            this.setProcessDefinition((ProcessDefinition)((OutlineEditPart)input).getModel());
        }
    }

    public void clearControls() {
        this.setSelectedSwimlane(null);
        this.swimlaneTable.removeAll();
        this.clearSwimlaneInfo();
    }

    private void clearSwimlaneInfo() {
        this.detailsArea.setVisible(false);
    }

    public void setProcessDefinition(ProcessDefinition newProcessDefinition) {
        if (this.processDefinition == newProcessDefinition) {
            return;
        }
        if (this.processDefinition != null) {
            this.processDefinition.removePropertyChangeListener(this);
        }
        this.clearControls();
        this.processDefinition = newProcessDefinition;
        if (this.processDefinition != null) {
            this.updateControls();
            this.processDefinition.addPropertyChangeListener(this);
        }
    }

    private void updateControls() {
        Swimlane[] swimlanes = this.processDefinition.getSwimlanes();
        int i = 0;
        while (i < swimlanes.length) {
            TableItem tableItem = new TableItem(this.swimlaneTable, 0);
            tableItem.setText(swimlanes[i].getName());
            tableItem.setData((Object)swimlanes[i]);
            tableItem.setImage(SharedImages.INSTANCE.getImage(swimlanes[i].getIconDescriptor()));
            ++i;
        }
        this.detailsArea.setVisible(this.selectedSwimlane != null);
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    private void hookListeners() {
    }

    private void unhookListeners() {
    }

    private void setSelectedSwimlane(Swimlane swimlane) {
        this.unhookListeners();
        if (this.selectedSwimlane != null) {
            this.selectedSwimlane.removePropertyChangeListener(this);
        }
        this.selectedSwimlane = swimlane;
        this.updateSwimlaneConfigurationComposite();
        if (this.selectedSwimlane != null) {
            this.selectedSwimlane.addPropertyChangeListener(this);
            this.hookListeners();
        }
        this.actionBarContributor.setRemoveSwimlaneEnabled(this.selectedSwimlane != null);
        this.detailsArea.setVisible(this.selectedSwimlane != null);
    }

    private void updateSwimlaneConfigurationComposite() {
        this.swimlaneConfigurationComposite.setSwimlane(this.selectedSwimlane);
    }

    public Swimlane getSelectedSwimlane() {
        return this.selectedSwimlane;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.swimlaneTable.isDisposed()) {
            return;
        }
        if ("swimlaneAdd".equals(evt.getPropertyName())) {
            TableItem tableItem = new TableItem(this.swimlaneTable, 0);
            Swimlane swimlane = (Swimlane)evt.getNewValue();
            tableItem.setText(swimlane.getName());
            tableItem.setData((Object)swimlane);
            tableItem.setImage(SharedImages.INSTANCE.getImage(swimlane.getIconDescriptor()));
            this.swimlaneTable.setSelection(tableItem);
            this.swimlaneTable.notifyListeners(13, new Event());
        } else if ("swimlaneRemove".equals(evt.getPropertyName())) {
            TableItem tableItem = this.getItemToRemove(evt.getOldValue());
            if (tableItem != null) {
                tableItem.dispose();
                this.swimlaneTable.notifyListeners(13, new Event());
            }
        } else if ("name".equals(evt.getPropertyName())) {
            TableItem tableItem = this.swimlaneTable.getItem(this.swimlaneTable.getSelectionIndex());
            tableItem.setText((String)evt.getNewValue());
        }
    }

    private TableItem getItemToRemove(Object object) {
        int i = 0;
        while (i < this.swimlaneTable.getItemCount()) {
            if (this.swimlaneTable.getItem(i).getData() == object) {
                return this.swimlaneTable.getItem(i);
            }
            ++i;
        }
        return null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }
}

