/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.net.URL;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.command.SwimlaneCreateCommand;
import org.jbpm.gd.jpdl.command.SwimlaneDeleteCommand;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.properties.SwimlaneContainerSection;

public class SwimlaneContainerSectionActionBarContributor {
    private SwimlaneContainerSection swimlaneSection;
    private ActionContributionItem addSwimlaneToolbarContributionItem;
    private ActionContributionItem removeSwimlaneToolbarContributionItem;
    private ActionContributionItem addSwimlaneMenuContributionItem;
    private ActionContributionItem removeSwimlaneMenuContributionItem;
    private Separator toolbarSeparator;
    private Separator menuSeparator;
    private Menu root;
    IContributionItem item;

    public SwimlaneContainerSectionActionBarContributor(SwimlaneContainerSection swimlaneSection) {
        this.setSwimlaneSection(swimlaneSection);
        this.createAddSwimlaneContributions();
        this.createSeparatorContributions();
        this.createRemoveSwimlaneContributions();
    }

    private void createSeparatorContributions() {
        this.toolbarSeparator = new Separator();
        this.menuSeparator = new Separator();
    }

    private void setSwimlaneSection(SwimlaneContainerSection swimlaneSection) {
        this.swimlaneSection = swimlaneSection;
    }

    public void activateContributions() {
        this.addAddSwimlaneAction();
        this.addSeparators();
        this.addRemoveSwimlaneAction();
        this.getActionBars().updateActionBars();
    }

    private void addSeparators() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getMenuManager().add((IContributionItem)this.menuSeparator);
    }

    public void deactivateContributions() {
        this.removeAddSwimlaneAction();
        this.removeSeparators();
        this.removeRemoveSwimlaneAction();
        this.getActionBars().updateActionBars();
    }

    private void removeSeparators() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.menuSeparator);
    }

    public void setRemoveSwimlaneEnabled(boolean enabled) {
        this.removeSwimlaneMenuContributionItem.getAction().setEnabled(enabled);
        this.removeSwimlaneToolbarContributionItem.getAction().setEnabled(enabled);
    }

    private void addAddSwimlaneAction() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.addSwimlaneToolbarContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.addSwimlaneMenuContributionItem);
    }

    private void createAddSwimlaneContributions() {
        this.addSwimlaneToolbarContributionItem = new ActionContributionItem(this.createAddSwimlaneAction());
        this.addSwimlaneMenuContributionItem = new ActionContributionItem(this.createAddSwimlaneAction());
    }

    private IAction createAddSwimlaneAction() {
        Action action = new Action(){

            public void run() {
                SwimlaneContainerSectionActionBarContributor.this.addNewSwimlane();
            }
        };
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_swimlane_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_swimlane_disabled.gif")));
        action.setToolTipText("Add a swimlane");
        action.setText("New Swimlane");
        return action;
    }

    private void addRemoveSwimlaneAction() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.removeSwimlaneToolbarContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.removeSwimlaneMenuContributionItem);
    }

    private void createRemoveSwimlaneContributions() {
        this.createRemoveSwimlaneAction();
        this.removeSwimlaneToolbarContributionItem = new ActionContributionItem(this.createRemoveSwimlaneAction());
        this.removeSwimlaneMenuContributionItem = new ActionContributionItem(this.createRemoveSwimlaneAction());
    }

    private IAction createRemoveSwimlaneAction() {
        Action action = new Action(){

            public void run() {
                SwimlaneContainerSectionActionBarContributor.this.removeSelectedSwimlane();
            }
        };
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_disabled.gif")));
        action.setToolTipText("Remove the selected swimlane");
        action.setText("Delete");
        action.setEnabled(false);
        return action;
    }

    private void addNewSwimlane() {
        ProcessDefinition processDefinition = this.swimlaneSection.getProcessDefinition();
        SwimlaneCreateCommand command = new SwimlaneCreateCommand(processDefinition.getFactory());
        command.setProcessDefinition(processDefinition);
        this.getCommandStack().execute((Command)command);
    }

    private void removeSelectedSwimlane() {
        SwimlaneDeleteCommand command = new SwimlaneDeleteCommand();
        command.setProcessDefinition(this.swimlaneSection.getProcessDefinition());
        command.setSwimlane(this.swimlaneSection.getSelectedSwimlane());
        this.getCommandStack().execute((Command)command);
    }

    private CommandStack getCommandStack() {
        return this.swimlaneSection.getCommandStack();
    }

    private void removeAddSwimlaneAction() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.addSwimlaneToolbarContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.addSwimlaneMenuContributionItem);
    }

    private void removeRemoveSwimlaneAction() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.removeSwimlaneToolbarContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.removeSwimlaneMenuContributionItem);
    }

    private IActionBars getActionBars() {
        return this.swimlaneSection.getTabbedPropertySheetPage().getSite().getActionBars();
    }

    public void createPopupMenu(Composite composite) {
        this.root = new Menu((Control)composite);
        composite.setMenu(this.root);
        this.root.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                SwimlaneContainerSectionActionBarContributor.this.disposePopupMenu();
                SwimlaneContainerSectionActionBarContributor.this.createPopupMenu();
            }
        });
    }

    private void disposePopupMenu() {
        MenuItem[] menuItems = this.root.getItems();
        int i = 0;
        while (i < menuItems.length) {
            menuItems[i].dispose();
            ++i;
        }
    }

    private void createPopupMenu() {
        this.createAddSwimlaneMenuItem();
        new MenuItem(this.root, 2);
        this.createRemoveSwimlaneMenuItem();
    }

    private String getDeleteImagePath() {
        String imagePath = this.swimlaneSection.getSelectedSwimlane() != null ? "/icons/full/obj16/delete_enabled.gif" : "/icons/full/obj16/delete_disabled.gif";
        return imagePath;
    }

    private void createAddSwimlaneMenuItem() {
        MenuItem addSwimlaneItem = new MenuItem(this.root, 8);
        addSwimlaneItem.setText("New Swimlane");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_swimlane_enabled.gif"));
        addSwimlaneItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        addSwimlaneItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwimlaneContainerSectionActionBarContributor.this.addNewSwimlane();
            }
        });
    }

    private void createRemoveSwimlaneMenuItem() {
        MenuItem removeSwimlaneItem = new MenuItem(this.root, 8);
        removeSwimlaneItem.setText("Delete");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry(this.getDeleteImagePath()));
        removeSwimlaneItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        removeSwimlaneItem.setEnabled(this.swimlaneSection.getSelectedSwimlane() != null);
        removeSwimlaneItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwimlaneContainerSectionActionBarContributor.this.removeSelectedSwimlane();
            }
        });
    }
}

