/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.gd.common.model.AbstractNamedElement;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.ActionElementContainer;
import org.jbpm.gd.jpdl.model.DescribableElement;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.EventContainer;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.ExceptionHandlerContainer;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Swimlane;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.TaskContainer;

public class ProcessDefinition
extends AbstractNamedElement
implements DescribableElement,
NodeElementContainer,
EventContainer,
ActionElementContainer,
TaskContainer,
ExceptionHandlerContainer {
    private List swimlanes = new ArrayList();
    private StartState startState;
    private List nodeElements = new ArrayList();
    private List actionElements = new ArrayList();
    private List events = new ArrayList();
    private List exceptionHandlers = new ArrayList();
    private List tasks = new ArrayList();
    private HashMap customProperties = new HashMap();
    private Description description;

    public void setDescription(Description newDescription) {
        Description oldDescription = this.description;
        this.description = newDescription;
        this.firePropertyChange("description", oldDescription, newDescription);
    }

    public Description getDescription() {
        return this.description;
    }

    public void setProperty(String name, String newValue) {
        String oldValue = (String)this.customProperties.get(name);
        this.customProperties.put(name, newValue);
        this.firePropertyChange("custom", new String[]{name, oldValue}, new String[]{name, newValue});
    }

    public String getProperty(String name) {
        return (String)this.customProperties.get(name);
    }

    public Map getProperties() {
        return new HashMap(this.customProperties);
    }

    public void addSwimlane(Swimlane swimlane) {
        this.swimlanes.add(swimlane);
        this.firePropertyChange("swimlaneAdd", null, swimlane);
    }

    public void removeSwimlane(Swimlane swimlane) {
        this.swimlanes.remove(swimlane);
        this.firePropertyChange("swimlaneRemove", swimlane, null);
    }

    public Swimlane[] getSwimlanes() {
        return this.swimlanes.toArray(new Swimlane[this.swimlanes.size()]);
    }

    public void addStartState(StartState startState) {
        if (this.startState != null) {
            return;
        }
        this.startState = startState;
        this.nodeElements.add(0, startState);
        this.firePropertyChange("startStateAdd", null, startState);
    }

    public void removeStartState(StartState startState) {
        if (this.startState != startState) {
            return;
        }
        this.startState = null;
        this.nodeElements.remove(0);
        this.firePropertyChange("startStateRemove", startState, null);
    }

    public StartState getStartState() {
        return this.startState;
    }

    public void addNodeElement(NodeElement nodeElement) {
        this.nodeElements.add(nodeElement);
        this.firePropertyChange("nodeElementAdd", null, nodeElement);
    }

    public void removeNodeElement(NodeElement nodeElement) {
        this.nodeElements.remove(nodeElement);
        this.firePropertyChange("nodeElementRemove", nodeElement, null);
    }

    public NodeElement[] getNodeElements() {
        return this.nodeElements.toArray(new NodeElement[this.nodeElements.size()]);
    }

    public void addActionElement(ActionElement actionElement) {
        this.actionElements.add(actionElement);
        this.firePropertyChange("actionElementAdd", null, actionElement);
    }

    public void removeActionElement(ActionElement actionElement) {
        this.actionElements.remove(actionElement);
        this.firePropertyChange("actionElementRemove", actionElement, null);
    }

    public ActionElement[] getActionElements() {
        return this.actionElements.toArray(new ActionElement[this.actionElements.size()]);
    }

    public void addEvent(Event event) {
        this.events.add(event);
        this.firePropertyChange("eventAdd", null, event);
    }

    public void removeEvent(Event event) {
        this.events.remove(event);
        this.firePropertyChange("eventRemove", event, null);
    }

    public Event[] getEvents() {
        return this.events.toArray(new Event[this.events.size()]);
    }

    public void addExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
        this.firePropertyChange("exceptionHandlerAdd", null, exceptionHandler);
    }

    public void removeExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandlers.remove(exceptionHandler);
        this.firePropertyChange("exceptionHandlerRemove", exceptionHandler, null);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return this.exceptionHandlers.toArray(new ExceptionHandler[this.exceptionHandlers.size()]);
    }

    public void addTask(Task task) {
        this.tasks.add(task);
        this.firePropertyChange("taskAdd", null, task);
    }

    public void removeTask(Task task) {
        this.tasks.remove(task);
        this.firePropertyChange("taskRemove", task, null);
    }

    public Task[] getTasks() {
        return this.tasks.toArray(new Task[this.tasks.size()]);
    }

    public boolean canAdd(NodeElement node) {
        return !this.nodeElements.contains(node) && node.isPossibleChildOf(this);
    }

    public NodeElement getNodeElementByName(String name) {
        NodeElement[] nodeElements = this.getNodeElements();
        int i = 0;
        while (i < nodeElements.length) {
            if (name.equals(nodeElements[i].getName())) {
                return nodeElements[i];
            }
            ++i;
        }
        return null;
    }

    public Swimlane getSwimlaneByName(String name) {
        Swimlane[] swimlanes = this.getSwimlanes();
        int i = 0;
        while (i < swimlanes.length) {
            if (swimlanes[i].getName().equals(name)) {
                return swimlanes[i];
            }
            ++i;
        }
        return null;
    }

    public String getFullyQualifiedName() {
        return "/";
    }
}

