/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.EventContainer;
import org.jbpm.gd.jpdl.model.MailAction;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.properties.ActionConfigurationComposite;
import org.jbpm.gd.jpdl.properties.CancelTimerConfigurationComposite;
import org.jbpm.gd.jpdl.properties.EventConfigurationComposite;
import org.jbpm.gd.jpdl.properties.EventContainerSectionActionBarContributor;
import org.jbpm.gd.jpdl.properties.MailActionConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ScriptConfigurationComposite;
import org.jbpm.gd.jpdl.properties.TimerConfigurationComposite;

public class EventContainerSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private Tree eventTree;
    private EventContainer eventContainer;
    private EventContainerSectionActionBarContributor actionBarContributor;
    private HashMap pagesMap = new HashMap();
    private EventConfigurationComposite eventConfigurationComposite;
    private ActionConfigurationComposite actionConfigurationComposite;
    private ScriptConfigurationComposite scriptConfigurationComposite;
    private TimerConfigurationComposite createTimerConfigurationComposite;
    private CancelTimerConfigurationComposite cancelTimerConfigurationComposite;
    private MailActionConfigurationComposite mailConfigurationComposite;
    private Event selectedEvent;
    private ActionElement selectedActionElement;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.actionBarContributor = new EventContainerSectionActionBarContributor(this);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createMasterArea(composite);
        this.createDetailsArea(composite);
    }

    private void createMasterArea(Composite composite) {
        this.eventTree = this.getWidgetFactory().createTree(composite, 68356);
        this.eventTree.setLayoutData((Object)this.createEventTreeLayoutData());
        this.eventTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EventContainerSection.this.handleEventTreeSelection();
            }
        });
        this.actionBarContributor.createPopupMenu((Composite)this.eventTree);
    }

    private void handleEventTreeSelection() {
        TreeItem[] selectedItems = this.eventTree.getSelection();
        if (selectedItems.length == 0) {
            this.unSelectAll();
        } else {
            SemanticElement element = (SemanticElement)selectedItems[0].getData();
            if (element instanceof Event) {
                this.selectEvent((Event)element);
            } else if (element instanceof ActionElement) {
                this.selectActionElement((ActionElement)element);
            }
        }
        this.updateDetailsArea();
    }

    private boolean somethingSelected() {
        return this.getSelectedEvent() != null || this.getSelectedActionElement() != null;
    }

    private void updateDetailsArea() {
        String id = null;
        if (this.getSelectedActionElement() != null) {
            id = this.getSelectedActionElement().getElementId();
        } else if (this.getSelectedEvent() != null) {
            id = this.getSelectedEvent().getElementId();
        }
        for (String key : this.pagesMap.keySet()) {
            ((Composite)this.pagesMap.get(key)).setVisible(key.equals(id));
        }
    }

    private void unSelectAll() {
        if (this.somethingSelected()) {
            this.selectActionElement(null);
        }
    }

    private void selectEvent(Event event) {
        if (event == this.getSelectedEvent() && this.selectedActionElement == null) {
            return;
        }
        this.actionBarContributor.setAddActionElementEnabled(event != null);
        this.actionBarContributor.setRemoveEnabled(event != null);
        if (this.selectedActionElement != null) {
            this.selectedActionElement.removePropertyChangeListener(this);
        }
        if (this.selectedEvent != null) {
            this.selectedEvent.removePropertyChangeListener(this);
        }
        this.selectedActionElement = null;
        this.selectedEvent = event;
        this.eventConfigurationComposite.setEvent(event);
        if (this.selectedEvent != null) {
            this.selectedEvent.addPropertyChangeListener(this);
        }
    }

    private void selectActionElement(ActionElement actionElement) {
        if (actionElement == this.getSelectedActionElement()) {
            return;
        }
        Event event = null;
        if (actionElement != null) {
            event = (Event)this.eventTree.getSelection()[0].getParentItem().getData();
        }
        this.selectEvent(event);
        this.selectedActionElement = actionElement;
        this.updateActionElementDetails();
        if (this.selectedActionElement != null) {
            this.selectedActionElement.addPropertyChangeListener(this);
        }
    }

    private void updateActionElementDetails() {
        if (this.selectedActionElement instanceof Action) {
            this.actionConfigurationComposite.setAction((Action)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof Script) {
            this.scriptConfigurationComposite.setScript((Script)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof CreateTimer) {
            this.createTimerConfigurationComposite.setTimer((CreateTimer)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof CancelTimer) {
            this.cancelTimerConfigurationComposite.setCancelTimer((CancelTimer)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof MailAction) {
            this.mailConfigurationComposite.setMailAction((MailAction)this.selectedActionElement);
        }
    }

    private FormData createEventTreeLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private void createDetailsArea(Composite composite) {
        this.createEventPage(composite);
        this.createActionPage(composite);
        this.createScriptPage(composite);
        this.createCreateTimerPage(composite);
        this.createCancelTimerPage(composite);
        this.createMailPage(composite);
    }

    private void createActionPage(Composite composite) {
        Composite actionPage = this.getWidgetFactory().createComposite(composite);
        actionPage.setLayout((Layout)new FormLayout());
        actionPage.setVisible(false);
        actionPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.pagesMap.put("org.jbpm.gd.jpdl.action", actionPage);
        this.actionConfigurationComposite = ActionConfigurationComposite.create(this.getWidgetFactory(), actionPage);
    }

    private void createEventPage(Composite composite) {
        Composite eventPage = this.getWidgetFactory().createFlatFormComposite(composite);
        eventPage.setVisible(false);
        eventPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.pagesMap.put("org.jbpm.gd.jpdl.event", eventPage);
        this.eventConfigurationComposite = EventConfigurationComposite.create(this.getWidgetFactory(), eventPage);
    }

    private void createScriptPage(Composite composite) {
        Composite scriptPage = this.getWidgetFactory().createComposite(composite);
        scriptPage.setLayout((Layout)new FormLayout());
        scriptPage.setVisible(false);
        scriptPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.pagesMap.put("org.jbpm.gd.jpdl.script", scriptPage);
        this.scriptConfigurationComposite = ScriptConfigurationComposite.create(this.getWidgetFactory(), scriptPage);
    }

    private void createCreateTimerPage(Composite composite) {
        Composite createTimerPage = this.getWidgetFactory().createComposite(composite);
        createTimerPage.setLayout((Layout)new FormLayout());
        createTimerPage.setVisible(false);
        createTimerPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.pagesMap.put("org.jbpm.gd.jpdl.createTimer", createTimerPage);
        this.createTimerConfigurationComposite = TimerConfigurationComposite.create(this.getWidgetFactory(), createTimerPage);
    }

    private void createCancelTimerPage(Composite composite) {
        Composite cancelTimerPage = this.getWidgetFactory().createComposite(composite);
        cancelTimerPage.setLayout((Layout)new FormLayout());
        cancelTimerPage.setVisible(false);
        cancelTimerPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.pagesMap.put("org.jbpm.gd.jpdl.cancelTimer", cancelTimerPage);
        this.cancelTimerConfigurationComposite = CancelTimerConfigurationComposite.create(this.getWidgetFactory(), cancelTimerPage);
    }

    private void createMailPage(Composite composite) {
        Composite mailPage = this.getWidgetFactory().createComposite(composite);
        mailPage.setLayout((Layout)new FormLayout());
        mailPage.setVisible(false);
        mailPage.setLayoutData((Object)this.createDetailsAreaLayoutData());
        this.mailConfigurationComposite = MailActionConfigurationComposite.create(this.getWidgetFactory(), mailPage);
    }

    private FormData createDetailsAreaLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.eventTree, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            this.setEventContainer((EventContainer)notationElement.getSemanticElement());
        } else if (input instanceof OutlineEditPart) {
            this.setEventContainer((EventContainer)((OutlineEditPart)input).getModel());
        }
    }

    private void clearControls() {
        this.eventTree.removeAll();
        Iterator iter = this.pagesMap.keySet().iterator();
        while (iter.hasNext()) {
            ((Composite)this.pagesMap.get(iter.next())).setVisible(false);
        }
    }

    private void setEventContainer(EventContainer newEventContainer) {
        if (this.eventContainer == newEventContainer) {
            return;
        }
        if (this.eventContainer != null) {
            this.eventContainer.removePropertyChangeListener(this);
        }
        this.clearControls();
        this.eventContainer = newEventContainer;
        if (this.eventContainer != null) {
            this.updateEventTree();
            this.eventContainer.addPropertyChangeListener(this);
        }
    }

    private void updateEventTree() {
        Event[] events = this.eventContainer.getEvents();
        int i = 0;
        while (i < events.length) {
            TreeItem eventItem = new TreeItem(this.eventTree, 0);
            eventItem.setText(this.getLabel(events[i]));
            eventItem.setData((Object)events[i]);
            eventItem.setImage(SharedImages.INSTANCE.getImage(events[i].getIconDescriptor()));
            eventItem.setExpanded(true);
            ActionElement[] actionElements = events[i].getActionElements();
            int j = 0;
            while (j < actionElements.length) {
                TreeItem actionElementItem = new TreeItem(eventItem, 0);
                actionElementItem.setText(this.getLabel(actionElements[j]));
                actionElementItem.setData((Object)actionElements[j]);
                actionElementItem.setImage(SharedImages.INSTANCE.getImage(actionElements[j].getIconDescriptor()));
                ++j;
            }
            ++i;
        }
    }

    private String getLabel(ActionElement actionElement) {
        String refName;
        String result = actionElement.getName();
        if (result != null && !"".equals(result)) {
            return result;
        }
        if (actionElement instanceof Action && (refName = ((Action)actionElement).getRefName()) != null && !"".equals(refName)) {
            return refName;
        }
        result = actionElement.getLabel();
        return result != null ? result.toLowerCase() : actionElement.getElementId();
    }

    public TabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.tabbedPropertySheetPage;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.eventTree.isDisposed()) {
            return;
        }
        if ("eventAdd".equals(evt.getPropertyName())) {
            TreeItem treeItem = new TreeItem(this.eventTree, 0);
            Event event = (Event)evt.getNewValue();
            treeItem.setText(this.getLabel(event));
            treeItem.setData((Object)event);
            treeItem.setImage(SharedImages.INSTANCE.getImage(event.getIconDescriptor()));
            this.eventTree.setSelection(treeItem);
            this.eventTree.notifyListeners(13, new org.eclipse.swt.widgets.Event());
        } else if ("actionElementAdd".equals(evt.getPropertyName())) {
            TreeItem selection = this.eventTree.getSelection()[0];
            if (selection.getData() instanceof ActionElement) {
                selection = selection.getParentItem();
            }
            TreeItem treeItem = new TreeItem(selection, 0);
            ActionElement actionElement = (ActionElement)evt.getNewValue();
            treeItem.setText(this.getLabel(actionElement));
            treeItem.setData((Object)actionElement);
            treeItem.setImage(SharedImages.INSTANCE.getImage(actionElement.getIconDescriptor()));
            this.eventTree.setSelection(treeItem);
            this.eventTree.notifyListeners(13, new org.eclipse.swt.widgets.Event());
        } else if ("eventRemove".equals(evt.getPropertyName()) || "actionElementRemove".equals(evt.getPropertyName())) {
            this.eventTree.getSelection()[0].dispose();
            this.eventTree.notifyListeners(13, new org.eclipse.swt.widgets.Event());
        } else if ("type".equals(evt.getPropertyName())) {
            String newValue = (String)evt.getNewValue();
            if (newValue == null || "".equals(newValue)) {
                newValue = "event";
            }
            this.eventTree.getSelection()[0].setText(newValue);
        } else if ("name".equals(evt.getPropertyName()) || "refName".equals(evt.getPropertyName())) {
            String newValue = (String)evt.getNewValue();
            if (newValue == null || "".equals(newValue)) {
                newValue = "action";
            }
            this.eventTree.getSelection()[0].setText(newValue);
        }
    }

    private String getLabel(Event event) {
        String label = event.getType();
        return label == null || "".equals(label) ? "event" : label;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public EventContainer getEventContainer() {
        return this.eventContainer;
    }

    public Event getSelectedEvent() {
        return this.selectedEvent;
    }

    public ActionElement getSelectedActionElement() {
        return this.selectedActionElement;
    }

    public void aboutToBeShown() {
        this.actionBarContributor.activateContributions();
    }

    public void aboutToBeHidden() {
        this.actionBarContributor.deactivateContributions();
    }
}

