/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.properties.ScriptDetailsConfigurationComposite;

public class ScriptDetailsSection
extends AbstractPropertySection {
    private ScriptDetailsConfigurationComposite scriptDetailsConfigurationComposite;
    private Script script;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite clientArea = this.getWidgetFactory().createFlatFormComposite(parent);
        this.scriptDetailsConfigurationComposite = ScriptDetailsConfigurationComposite.create(this.getWidgetFactory(), clientArea);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            input = notationElement.getSemanticElement();
        } else if (input instanceof OutlineEditPart) {
            input = ((OutlineEditPart)input).getModel();
        }
        if (input instanceof Script) {
            this.setScript((Script)input);
        }
    }

    private void setScript(Script script) {
        this.script = script;
    }

    public void refresh() {
        if (this.script != null) {
            this.scriptDetailsConfigurationComposite.setScript(this.script);
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}

