/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.properties.TaskFormGenerationDialog;
import org.jbpm.gd.jpdl.util.BooleanTypeHelper;

public class TaskDetailsConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Task task;
    private Label duedateLabel;
    private Text duedateText;
    private Label priorityLabel;
    private CCombo priorityCombo;
    private Button blockingButton;
    private Button signallingButton;
    private Button notifyButton;
    private Button formButton;

    public static TaskDetailsConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        TaskDetailsConfigurationComposite result = new TaskDetailsConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private TaskDetailsConfigurationComposite() {
    }

    public void setTask(Task task) {
        if (this.task == task) {
            return;
        }
        this.unhookListeners();
        this.task = task;
        this.clearControls();
        if (task != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.duedateText.addFocusListener((FocusListener)this);
        this.priorityCombo.addFocusListener((FocusListener)this);
        this.priorityCombo.addSelectionListener((SelectionListener)this);
        this.blockingButton.addSelectionListener((SelectionListener)this);
        this.signallingButton.addSelectionListener((SelectionListener)this);
        this.notifyButton.addSelectionListener((SelectionListener)this);
        this.formButton.addSelectionListener((SelectionListener)this);
    }

    private void unhookListeners() {
        this.duedateText.removeFocusListener((FocusListener)this);
        this.priorityCombo.removeFocusListener((FocusListener)this);
        this.priorityCombo.removeSelectionListener((SelectionListener)this);
        this.blockingButton.removeSelectionListener((SelectionListener)this);
        this.signallingButton.removeSelectionListener((SelectionListener)this);
        this.notifyButton.removeSelectionListener((SelectionListener)this);
        this.formButton.removeSelectionListener((SelectionListener)this);
    }

    private void clearControls() {
        this.duedateText.setText("");
        this.priorityCombo.setText("");
        this.blockingButton.setSelection(false);
        this.signallingButton.setSelection(false);
        this.notifyButton.setSelection(false);
    }

    private void updateControls() {
        this.duedateText.setText(this.task.getDueDate() != null ? this.task.getDueDate() : "");
        this.priorityCombo.setText(this.task.getPriority());
        this.blockingButton.setSelection(BooleanTypeHelper.booleanValue(this.task.getBlocking()));
        this.signallingButton.setSelection(BooleanTypeHelper.booleanValue(this.task.getSignalling()));
        this.notifyButton.setSelection(BooleanTypeHelper.booleanValue(this.task.getNotify()));
    }

    private void create() {
        this.duedateLabel = this.widgetFactory.createLabel(this.parent, "Due Date");
        this.duedateText = this.widgetFactory.createText(this.parent, "");
        this.priorityLabel = this.widgetFactory.createLabel(this.parent, "Priority");
        this.priorityCombo = this.widgetFactory.createCCombo(this.parent);
        this.priorityCombo.setItems(this.getPriorityItems());
        this.priorityCombo.setEditable(true);
        this.blockingButton = this.widgetFactory.createButton(this.parent, "Blocking", 32);
        this.signallingButton = this.widgetFactory.createButton(this.parent, "Signalling", 32);
        this.notifyButton = this.widgetFactory.createButton(this.parent, "Notify", 32);
        this.formButton = this.widgetFactory.createButton(this.parent, "Generate Form...", 8);
        this.duedateLabel.setLayoutData((Object)this.createDuedateLabelLayoutData());
        this.duedateText.setLayoutData((Object)this.createDuedateTextLayoutData());
        this.priorityLabel.setLayoutData((Object)this.createPriorityLabelLayoutData());
        this.priorityCombo.setLayoutData((Object)this.createPriorityComboLayoutData());
        this.blockingButton.setLayoutData((Object)this.createBlockingButtonLayoutData());
        this.signallingButton.setLayoutData((Object)this.createSignallingButtonLayoutData());
        this.notifyButton.setLayoutData((Object)this.createNotifyButtonLayoutData());
        this.formButton.setLayoutData((Object)this.createFormButtonLayoutData());
    }

    private String[] getPriorityItems() {
        return new String[]{"highest", "high", "normal", "low", "lowest"};
    }

    private FormData createDuedateLabelLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 2);
        data.left = new FormAttachment(0, 0);
        return data;
    }

    private FormData createDuedateTextLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment((Control)this.duedateLabel, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createPriorityLabelLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.duedateText, 2);
        data.left = new FormAttachment(0, 0);
        return data;
    }

    private FormData createPriorityComboLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.duedateText, 0);
        data.left = new FormAttachment((Control)this.duedateLabel, 0);
        data.right = new FormAttachment((Control)this.blockingButton);
        return data;
    }

    private FormData createBlockingButtonLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.duedateText, 2);
        data.right = new FormAttachment((Control)this.signallingButton, 0);
        return data;
    }

    private FormData createSignallingButtonLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.duedateText, 2);
        data.right = new FormAttachment((Control)this.notifyButton, 0);
        return data;
    }

    private FormData createNotifyButtonLayoutData() {
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.duedateText, 2);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createFormButtonLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.priorityCombo, 0);
        return data;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.formButton) {
            this.handleFormButtonSelected();
        } else if (e.widget == this.priorityCombo) {
            this.handlePriorityComboEdited();
        } else if (e.widget == this.blockingButton) {
            this.handleBlockingButtonSelected();
        } else if (e.widget == this.signallingButton) {
            this.handleSignallingButtonSelected();
        } else if (e.widget == this.notifyButton) {
            this.handleNotifyButtonSelected();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.handleEdited(e.widget);
    }

    private void handleFormButtonSelected() {
        String name = this.task.getName();
        if (name == null || "".equals(name)) {
            new MessageDialog(null, "Unnamed Task", null, "The task for which you want to generate a form has no name. Please return to the 'Name' field on the 'General' properties tab for this task and enter a name before trying to generate the form again.", 2, new String[]{"OK"}, 0).open();
        } else {
            new TaskFormGenerationDialog(this.parent.getShell(), name).open();
        }
    }

    private void handleBlockingButtonSelected() {
        if (this.blockingButton.getSelection()) {
            this.task.setBlocking("true");
        } else {
            this.task.setBlocking("false");
        }
    }

    private void handleSignallingButtonSelected() {
        if (this.signallingButton.getSelection()) {
            this.task.setSignalling("true");
        } else {
            this.task.setSignalling("false");
        }
    }

    private void handleNotifyButtonSelected() {
        if (this.notifyButton.getSelection()) {
            this.task.setNotify("true");
        } else {
            this.task.setNotify("false");
        }
    }

    private void handleEdited(Widget widget) {
        if (widget == this.duedateText) {
            this.task.setDueDate("".equals(this.duedateText.getText()) ? null : this.duedateText.getText());
        } else if (widget == this.priorityCombo) {
            this.handlePriorityComboEdited();
        }
    }

    private void handlePriorityComboEdited() {
        this.task.setPriority(this.priorityCombo.getText());
    }
}

