/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.util;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.jbpm.gd.jpdl.util.VariableTableItemWrapper;

public class VariableTableCellClickedResolver
implements MouseListener {
    private Table table;
    private VariableTableItemWrapper selectedWrapper;

    public VariableTableCellClickedResolver(Table table) {
        this.table = table;
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        int column;
        TableItem item = this.getSelectedTableItem();
        if (item == null) {
            return;
        }
        if (this.selectedWrapper != null) {
            this.selectedWrapper.cancelEditing();
            this.selectedWrapper = null;
        }
        if ((column = this.getSelectedColumn(e.x, e.y)) == -1) {
            return;
        }
        if (column == 1 || column == 2) {
            this.selectedWrapper = (VariableTableItemWrapper)item.getData();
            this.selectedWrapper.editCell(column);
        }
    }

    public void mouseUp(MouseEvent e) {
    }

    private TableItem getSelectedTableItem() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length > 0) {
            return selection[0];
        }
        return null;
    }

    private int getSelectedColumn(int x, int y) {
        int columnToEdit = -1;
        int columns = this.table.getColumnCount();
        TableItem tableItem = this.getSelectedTableItem();
        if (tableItem == null) {
            return -1;
        }
        int i = 0;
        while (i < columns) {
            Rectangle bounds = this.getBounds(tableItem, i);
            if (bounds.contains(x, y)) {
                columnToEdit = i;
                break;
            }
            ++i;
        }
        return columnToEdit;
    }

    private Rectangle getBounds(TableItem item, int columnIndex) {
        return item.getBounds(columnIndex);
    }
}

