/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.util;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.model.Variable;

public class VariableTableItemWrapper
implements DisposeListener,
SelectionListener,
FocusListener {
    private TableItem tableItem;
    private Variable variable;
    private Button readButton;
    private Button writeButton;
    private Button requiredButton;
    private Text nameText;
    private Text mappedNameText;

    public VariableTableItemWrapper(Table table, Variable variable) {
        this.variable = variable;
        this.initializeTableItem(table);
        this.initializeNameText(table);
        this.initializeReadButton(table);
        this.initializeWriteButton(table);
        this.initializeRequiredButton(table);
        this.initializeMappedNameText(table);
    }

    private void initializeNameText(Table table) {
        this.nameText = this.createText(table, 1);
        this.nameText.addSelectionListener((SelectionListener)this);
        this.nameText.addFocusListener((FocusListener)this);
        this.nameText.setText(this.getName());
    }

    private void initializeMappedNameText(Table table) {
        this.mappedNameText = this.createText(table, 2);
        this.mappedNameText.addSelectionListener((SelectionListener)this);
        this.mappedNameText.addFocusListener((FocusListener)this);
        this.mappedNameText.setText(this.getMappedName());
    }

    private void initializeReadButton(Table table) {
        this.readButton = this.createButton(table, 3);
        this.readButton.addSelectionListener((SelectionListener)this);
        this.readButton.setSelection(this.variable.isReadable());
    }

    private void initializeWriteButton(Table table) {
        this.writeButton = this.createButton(table, 4);
        this.writeButton.addSelectionListener((SelectionListener)this);
        this.writeButton.setSelection(this.variable.isWritable());
    }

    private void initializeRequiredButton(Table table) {
        this.requiredButton = this.createButton(table, 5);
        this.requiredButton.addSelectionListener((SelectionListener)this);
        this.requiredButton.setSelection(this.variable.isRequired());
    }

    private Button createButton(Table table, int index) {
        TableEditor checkboxEditor = new TableEditor(table);
        Button result = new Button((Composite)table, 32);
        result.pack();
        checkboxEditor.minimumWidth = result.getSize().x;
        checkboxEditor.horizontalAlignment = 0x1000000;
        checkboxEditor.setEditor((Control)result, this.tableItem, index);
        return result;
    }

    private Text createText(Table table, int index) {
        TableEditor textEditor = new TableEditor(table);
        Text result = new Text((Composite)table, 0);
        result.pack();
        textEditor.minimumWidth = result.getSize().x;
        textEditor.horizontalAlignment = 16384;
        textEditor.grabHorizontal = true;
        textEditor.setEditor((Control)result, this.tableItem, index);
        result.setVisible(false);
        return result;
    }

    private void initializeTableItem(Table table) {
        this.tableItem = new TableItem(table, 0);
        this.tableItem.addDisposeListener((DisposeListener)this);
        this.tableItem.setData((Object)this);
        this.tableItem.setText(1, this.getName());
        this.tableItem.setText(5, this.getMappedName());
    }

    public void widgetDisposed(DisposeEvent e) {
        this.tableItem.removeDisposeListener((DisposeListener)this);
        this.nameText.removeSelectionListener((SelectionListener)this);
        this.nameText.removeFocusListener((FocusListener)this);
        this.mappedNameText.removeSelectionListener((SelectionListener)this);
        this.mappedNameText.removeFocusListener((FocusListener)this);
        this.readButton.removeSelectionListener((SelectionListener)this);
        this.writeButton.removeSelectionListener((SelectionListener)this);
        this.requiredButton.removeSelectionListener((SelectionListener)this);
        this.nameText.dispose();
        this.mappedNameText.dispose();
        this.readButton.dispose();
        this.writeButton.dispose();
        this.requiredButton.dispose();
    }

    private String calculateAccessString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.readButton.getSelection()) {
            stringBuffer.append("read,");
        }
        if (this.writeButton.getSelection()) {
            stringBuffer.append("write,");
        }
        if (this.requiredButton.getSelection()) {
            stringBuffer.append("required ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1).toString();
    }

    public void editCell(int column) {
        if (column == 1) {
            this.editName();
        } else if (column == 2) {
            this.editMappedName();
        }
    }

    private void editMappedName() {
        this.nameText.setVisible(false);
        this.mappedNameText.setVisible(true);
        this.mappedNameText.setText(this.getMappedName());
        this.mappedNameText.selectAll();
        this.mappedNameText.setFocus();
    }

    private void editName() {
        this.nameText.setVisible(true);
        this.nameText.setText(this.getName());
        this.nameText.setFocus();
        this.nameText.selectAll();
    }

    public void cancelEditing() {
        this.applyName();
        this.applyMappedName();
    }

    private void applyMappedName() {
        this.mappedNameText.setVisible(false);
        this.tableItem.setText(2, this.getMappedName());
    }

    private String getMappedName() {
        return this.variable.getMappedName() == null ? "" : this.variable.getMappedName();
    }

    private void applyName() {
        this.nameText.setVisible(false);
        this.tableItem.setText(1, this.getName());
    }

    private String getName() {
        return this.variable.getName() == null ? "" : this.variable.getName();
    }

    public TableItem getTableItem() {
        return this.tableItem;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.readButton || e.widget == this.writeButton || e.widget == this.requiredButton) {
            this.variable.setAccess(this.calculateAccessString());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (e.widget == this.nameText) {
            this.variable.setName(this.nameText.getText());
            this.applyName();
        } else if (e.widget == this.mappedNameText) {
            this.variable.setMappedName(this.mappedNameText.getText());
            this.applyMappedName();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.cancelEditing();
    }
}

