/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Handler;

public class HandlerDomAdapter
extends XmlAdapter {
    private static HashMap NODE_TYPES = null;

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("genericElement", "genericElement");
        }
        return NODE_TYPES;
    }

    protected String getDefaultValue(String attributeName) {
        if ("config-type".equals(attributeName)) {
            return "field";
        }
        return super.getDefaultValue(attributeName);
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        Handler handler = (Handler)jpdlElement;
        handler.setConfigInfo(this.getTextContent());
        handler.setClassName(this.getAttribute("class"));
        handler.setConfigType(this.getAttribute("config-type"));
        handler.addPropertyChangeListener(this);
    }

    protected void initialize() {
        super.initialize();
        Handler handler = (Handler)this.getSemanticElement();
        if (handler != null) {
            GenericElement[] genericElements = handler.getGenericElements();
            int i = 0;
            while (i < genericElements.length) {
                this.addElement(genericElements[i]);
                ++i;
            }
            this.setTextContent(handler.getConfigInfo());
            this.setAttribute("class", handler.getClassName());
            this.setAttribute("config-type", handler.getConfigType());
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("configInfo".equals(evt.getPropertyName())) {
            this.setTextContent((String)evt.getNewValue());
        } else if ("className".equals(evt.getPropertyName())) {
            this.setAttribute("class", (String)evt.getNewValue());
        } else if ("configType".equals(evt.getPropertyName())) {
            this.setAttribute("config-type", (String)evt.getNewValue());
        } else if ("genericElementAdd".equals(evt.getPropertyName())) {
            this.addElement((SemanticElement)evt.getNewValue());
        } else if ("genericElementRemove".equals(evt.getPropertyName())) {
            this.removeElement((SemanticElement)evt.getOldValue());
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        Handler handler = (Handler)this.getSemanticElement();
        if ("#text".equals(name)) {
            handler.setConfigInfo(newValue);
        } else if ("class".equals(name)) {
            handler.setClassName(newValue);
        } else if ("config-type".equals(name)) {
            handler.setConfigType(newValue);
        }
    }

    protected SemanticElement createSemanticElementFor(XmlAdapter child) {
        if ("genericElement".equals(child.getElementType())) {
            return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.genericElement");
        }
        return super.createSemanticElementFor(child);
    }

    protected void doModelAdd(XmlAdapter child) {
    }

    protected void doModelRemove(XmlAdapter child) {
    }
}

