/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import edu.uci.ics.jung.algorithms.blockmodel.EquivalenceAlgorithm;
import edu.uci.ics.jung.algorithms.blockmodel.EquivalenceRelation;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;

public class StructurallyEquivalent
implements EquivalenceAlgorithm {
    static StructurallyEquivalent instance = null;
    public static int count = 0;

    public static StructurallyEquivalent getInstance() {
        if (instance == null) {
            instance = new StructurallyEquivalent();
        }
        return instance;
    }

    public EquivalenceRelation getEquivalences(Graph g) {
        return this.createEquivalenceClasses(g, this.checkEquivalent(g));
    }

    protected EquivalenceRelation createEquivalenceClasses(Graph g, Set s) {
        HashSet rv = new HashSet();
        HashMap<Object, HashSet<Object>> intermediate = new HashMap<Object, HashSet<Object>>();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            Pair p = (Pair)iter.next();
            HashSet<Object> res = (HashSet<Object>)intermediate.get(p.getFirst());
            if (res == null) {
                res = (Set)intermediate.get(p.getSecond());
            }
            if (res == null) {
                res = new HashSet<Object>();
            }
            res.add(p.getFirst());
            res.add(p.getSecond());
            intermediate.put(p.getFirst(), res);
            intermediate.put(p.getSecond(), res);
        }
        rv.addAll(intermediate.values());
        return new EquivalenceRelation(rv, g);
    }

    public Set checkEquivalent(Graph g) {
        HashSet<Pair> rv = new HashSet<Pair>();
        HashSet<Vertex> alreadyEquivalent = new HashSet<Vertex>();
        ArrayList l = new ArrayList(g.getVertices());
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            Vertex v1 = (Vertex)iter.next();
            if (alreadyEquivalent.contains(v1)) continue;
            ListIterator iterator = l.listIterator(l.indexOf(v1) + 1);
            while (iterator.hasNext()) {
                Vertex v2 = (Vertex)iterator.next();
                if (alreadyEquivalent.contains(v2) || !this.canpossiblycompare(v1, v2) || !this.isStructurallyEquivalent(v1, v2)) continue;
                Pair p = new Pair(v1, v2);
                alreadyEquivalent.add(v2);
                rv.add(p);
            }
        }
        return rv;
    }

    protected boolean isStructurallyEquivalent(Vertex v1, Vertex v2) {
        boolean b;
        ++count;
        if (v1.degree() != v2.degree()) {
            return false;
        }
        HashSet n1 = new HashSet(v1.getPredecessors());
        n1.remove(v2);
        n1.remove(v1);
        HashSet n2 = new HashSet(v2.getPredecessors());
        n2.remove(v1);
        n2.remove(v2);
        HashSet o1 = new HashSet(v1.getSuccessors());
        HashSet o2 = new HashSet(v2.getSuccessors());
        o1.remove(v1);
        o1.remove(v2);
        o2.remove(v1);
        o2.remove(v2);
        boolean bl = b = ((Object)n1).equals(n2) && ((Object)o1).equals(o2);
        if (!b) {
            return b;
        }
        b &= v1.isSuccessorOf(v2) == v1.isSuccessorOf(v2);
        return b &= v1.isSuccessorOf(v1) == v2.isSuccessorOf(v2);
    }

    protected boolean canpossiblycompare(Vertex v1, Vertex v2) {
        return true;
    }
}

