/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.utils;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import edu.uci.ics.jung.utils.UserDataFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.collections.IteratorUtils;

public class UnifiedUserData
extends UserData
implements UserDataFactory {
    protected static final Map key_meta_map = new HashMap();

    protected Map getKeyMap(Object key) {
        WeakHashMap key_map = (WeakHashMap)key_meta_map.get(key);
        if (key_map == null) {
            key_map = new WeakHashMap();
            key_meta_map.put(key, key_map);
        }
        return key_map;
    }

    public void addUserDatum(Object key, Object value, UserDataContainer.CopyAction shared) {
        if (key == null) {
            throw new IllegalArgumentException("Key must not be null");
        }
        Map key_map = this.getKeyMap(key);
        if (key_map.containsKey(this)) {
            throw new IllegalArgumentException("Key <" + key + "> had already been added to object " + this);
        }
        Pair object_value = new Pair(value, shared);
        key_map.put(this, object_value);
    }

    public void importUserData(UserDataContainer udc) {
        Iterator keyIt = udc.getUserDatumKeyIterator();
        while (keyIt.hasNext()) {
            Object key = keyIt.next();
            Object value = udc.getUserDatum(key);
            UserDataContainer.CopyAction action = udc.getUserDatumCopyAction(key);
            Object newValue = action.onCopy(value, udc, this);
            try {
                if (newValue == null) continue;
                this.addUserDatum(key, newValue, action);
            }
            catch (IllegalArgumentException iae) {
                List userDataKeys = IteratorUtils.toList((Iterator)udc.getUserDatumKeyIterator());
                throw new FatalException("Copying <" + key + "> of " + userDataKeys + " into a container that started with some keys ", iae);
            }
        }
    }

    public void setUserDatum(Object key, Object value, UserDataContainer.CopyAction shared) {
        this.getKeyMap(key).put(this, new Pair(value, shared));
    }

    public Object getUserDatum(Object key) {
        Pair value_pair = this.getUserDatumValuePair(key);
        if (value_pair == null) {
            return null;
        }
        return value_pair.getFirst();
    }

    protected Pair getUserDatumValuePair(Object key) {
        return (Pair)this.getKeyMap(key).get(this);
    }

    public Object removeUserDatum(Object key) {
        Object o = this.getUserDatum(key);
        Map key_map = this.getKeyMap(key);
        key_map.remove(this);
        if (key_map.isEmpty()) {
            key_meta_map.remove(key_map);
        }
        return o;
    }

    public Iterator getUserDatumKeyIterator() {
        LinkedList keys = new LinkedList();
        Iterator iter = key_meta_map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Map key_map = this.getKeyMap(key);
            if (!key_map.containsKey(this)) continue;
            keys.add(key);
        }
        return keys.iterator();
    }

    public boolean containsUserDatumKey(Object key) {
        return ((Map)key_meta_map.get(key)).containsKey(this);
    }

    public UserDataContainer.CopyAction getUserDatumCopyAction(Object key) {
        Pair value_pair = this.getUserDatumValuePair(key);
        if (value_pair == null) {
            return null;
        }
        return (UserDataContainer.CopyAction)value_pair.getSecond();
    }

    public UserDataContainer getInstance() {
        return new UnifiedUserData();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

