/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int maxLength = 13;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;

    TimestamptzAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 181, 181, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    TimestamptzAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 181, 181, s, false);
        this.initForDescribe(181, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.externalType = n;
        }
        this.internalTypeMaxLength = 13;
        if (n2 > 0 && n2 < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = n2;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int n) throws SQLException {
        int n2;
        int n3;
        int n4;
        String string;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n5 = this.columnIndex + this.byteLength * n;
        int n6 = 0;
        if ((this.oracleTZ1(n5) & REGIONIDBIT) != 0) {
            n6 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n5));
            if (TIMEZONETAB.checkID(n6 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n5)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n6);
            }
            string = new String(ZONEIDMAP.getRegion(n6));
        } else {
            int n7 = this.oracleTZ1(n5) - OFFSET_HOUR;
            int n8 = this.oracleTZ2(n5) - OFFSET_MINUTE;
            string = new String(n7 + ":" + n8);
        }
        TimeZone timeZone = TimeZone.getTimeZone(string);
        Calendar calendar = Calendar.getInstance(timeZone);
        int n9 = ((this.rowSpaceByte[0 + n5] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n5] & 0xFF) - 100;
        calendar.set(1, n9);
        calendar.set(2, this.oracleMonth(n5));
        calendar.set(5, this.oracleDay(n5));
        calendar.set(11, this.oracleHour(n5));
        calendar.set(12, this.oracleMin(n5));
        calendar.set(13, this.oracleSec(n5));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n5) & REGIONIDBIT) != 0) {
            n4 = TIMEZONETAB.getOffset(calendar, n6);
            n3 = timeZone.inDaylightTime(calendar.getTime());
            n2 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n4));
            if (n3 == 0 && n2 != 0) {
                calendar.add(14, -1 * timeZone.getDSTSavings());
            } else if (n3 != 0 && n2 == 0) {
                calendar.add(14, timeZone.getDSTSavings());
            }
            calendar.add(14, n4);
        } else {
            calendar.add(10, this.oracleTZ1(n5) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n5) - OFFSET_MINUTE);
        }
        n9 = calendar.get(1);
        n4 = calendar.get(2) + 1;
        n3 = calendar.get(5);
        n2 = calendar.get(11);
        int n10 = calendar.get(12);
        int n11 = calendar.get(13);
        int n12 = this.oracleNanos(n5);
        return n9 + "-" + n4 + "-" + n3 + " " + n2 + "." + n10 + "." + n11 + "." + n12 + " " + string;
    }

    java.sql.Date getDate(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n2 = this.columnIndex + this.byteLength * n;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n2) & REGIONIDBIT) != 0) {
            int n4 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n2));
            if (TIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n2)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n4);
            }
            int n5 = TIMEZONETAB.getOffset(calendar, n4);
            boolean bl = timeZone.inDaylightTime(calendar.getTime());
            boolean bl2 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n5));
            if (!bl && bl2) {
                calendar.add(14, -1 * timeZone.getDSTSavings());
            } else if (bl && !bl2) {
                calendar.add(14, timeZone.getDSTSavings());
            }
            calendar.add(10, n5 / 3600000);
            calendar.add(12, n5 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n2) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n2) - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        return new java.sql.Date(l);
    }

    Time getTime(int n) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n2 = this.columnIndex + this.byteLength * n;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n3 = ((this.rowSpaceByte[0 + n2] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n2] & 0xFF) - 100;
        calendar.set(1, n3);
        calendar.set(2, this.oracleMonth(n2));
        calendar.set(5, this.oracleDay(n2));
        calendar.set(11, this.oracleHour(n2));
        calendar.set(12, this.oracleMin(n2));
        calendar.set(13, this.oracleSec(n2));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n2) & REGIONIDBIT) != 0) {
            int n4 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n2));
            if (TIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n2)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n4);
            }
            int n5 = TIMEZONETAB.getOffset(calendar, n4);
            boolean bl = timeZone.inDaylightTime(calendar.getTime());
            boolean bl2 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n5));
            if (!bl && bl2) {
                calendar.add(14, -1 * timeZone.getDSTSavings());
            } else if (bl && !bl2) {
                calendar.add(14, timeZone.getDSTSavings());
            }
            calendar.add(10, n5 / 3600000);
            calendar.add(12, n5 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n2) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n2) - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        return new Time(l);
    }

    Timestamp getTimestamp(int n) throws SQLException {
        int n2;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] == -1) {
            return null;
        }
        int n3 = this.columnIndex + this.byteLength * n;
        TimeZone timeZone = this.statement.getDefaultTimeZone();
        Calendar calendar = Calendar.getInstance(timeZone);
        int n4 = ((this.rowSpaceByte[0 + n3] & 0xFF) - 100) * 100 + (this.rowSpaceByte[1 + n3] & 0xFF) - 100;
        calendar.set(1, n4);
        calendar.set(2, this.oracleMonth(n3));
        calendar.set(5, this.oracleDay(n3));
        calendar.set(11, this.oracleHour(n3));
        calendar.set(12, this.oracleMin(n3));
        calendar.set(13, this.oracleSec(n3));
        calendar.set(14, 0);
        if ((this.oracleTZ1(n3) & REGIONIDBIT) != 0) {
            int n5 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(n3));
            if (TIMEZONETAB.checkID(n5 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(n3)))) {
                TIMEZONETAB.updateTable(this.statement.connection, n5);
            }
            int n6 = TIMEZONETAB.getOffset(calendar, n5);
            boolean bl = timeZone.inDaylightTime(calendar.getTime());
            n2 = timeZone.inDaylightTime(new Date(calendar.getTimeInMillis() + (long)n6)) ? 1 : 0;
            if (!bl && n2 != 0) {
                calendar.add(14, -1 * timeZone.getDSTSavings());
            } else if (bl && n2 == 0) {
                calendar.add(14, timeZone.getDSTSavings());
            }
            calendar.add(10, n6 / 3600000);
            calendar.add(12, n6 % 3600000 / 60000);
        } else {
            calendar.add(10, this.oracleTZ1(n3) - OFFSET_HOUR);
            calendar.add(12, this.oracleTZ2(n3) - OFFSET_MINUTE);
        }
        long l = calendar.getTime().getTime();
        Timestamp timestamp = new Timestamp(l);
        n2 = this.oracleNanos(n3);
        timestamp.setNanos(n2);
        return timestamp;
    }

    Object getObject(int n) throws SQLException {
        return this.getTIMESTAMPTZ(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getTIMESTAMPTZ(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getTIMESTAMPTZ(n);
    }

    TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            byte[] byArray = new byte[13];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, 13);
            tIMESTAMPTZ = new TIMESTAMPTZ(byArray);
        }
        return tIMESTAMPTZ;
    }

    static int setHighOrderbits(int n) {
        return (n & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int n) {
        return (n & 0x3F) << 2;
    }

    static int getHighOrderbits(int n) {
        return (n & 0x7F) << 6;
    }

    static int getLowOrderbits(int n) {
        return (n & 0xFC) >> 2;
    }
}

