/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.common.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jbpm.gd.common.editor.ContentProvider;
import org.jbpm.gd.common.model.NamedElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNodeContainer;
import org.jbpm.gd.common.notation.BendPoint;
import org.jbpm.gd.common.notation.Edge;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.notation.NotationMapping;
import org.jbpm.gd.common.notation.RootContainer;
import org.jbpm.gd.jpdl.Logger;

public abstract class AbstractContentProvider
implements ContentProvider {
    protected abstract SemanticElement getEdgeSemanticElement(Node var1, Element var2, int var3);

    protected abstract SemanticElement getNodeSemanticElement(NodeContainer var1, Element var2, int var3);

    protected abstract void addNodes(NodeContainer var1, Element var2);

    protected abstract void addEdges(Node var1, Element var2);

    protected abstract SemanticElement findDestination(Edge var1, Node var2);

    protected String getRootNotationInfoElement() {
        return "<root-container/>";
    }

    protected String createInitialNotationInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("\n\n");
        buffer.append(this.getRootNotationInfoElement());
        return buffer.toString();
    }

    protected String getNotationInfoFileName(String semanticInfoFileName) {
        return ".gpd." + semanticInfoFileName;
    }

    protected String getSemanticInfoFileName(String notationInfoFileName) {
        return notationInfoFileName.substring(5);
    }

    protected void processRootContainer(RootContainer rootContainer, Element notationInfo) {
        this.addDimension(rootContainer, notationInfo);
        this.addNodes(rootContainer, notationInfo);
        this.postProcess(rootContainer);
    }

    protected void addNodes(NodeContainer nodeContainer, SemanticElement[] semanticElements, Element notationInfo) {
        List notationInfoElements = notationInfo == null ? new ArrayList() : notationInfo.elements();
        int i = 0;
        while (i < semanticElements.length) {
            Element notationInfoElement = null;
            if (notationInfoElements.size() >= i + 1) {
                notationInfoElement = (Element)notationInfoElements.get(i);
            }
            this.addNode(nodeContainer, semanticElements[i], notationInfoElement);
            ++i;
        }
    }

    protected void addEdges(Node node, SemanticElement[] semanticElements, Element notationInfo) {
        List notationInfoElements = notationInfo == null ? new ArrayList() : notationInfo.elements();
        int i = 0;
        while (i < semanticElements.length) {
            Element notationInfoElement = null;
            if (notationInfoElements.size() >= i + 1) {
                notationInfoElement = (Element)notationInfoElements.get(i);
            }
            this.addEdge(node, semanticElements[i], notationInfoElement);
            ++i;
        }
    }

    protected void addNode(NodeContainer nodeContainer, SemanticElement semanticElement, Element notationInfoElement) {
        String notationElementId = NotationMapping.getNotationElementId(semanticElement.getElementId());
        Node notationElement = (Node)nodeContainer.getFactory().create(notationElementId);
        notationElement.setSemanticElement(semanticElement);
        notationElement.register();
        nodeContainer.addNode(notationElement);
        semanticElement.addPropertyChangeListener(notationElement);
        this.processNode(notationElement, notationInfoElement);
        if (notationElement instanceof NodeContainer) {
            this.addNodes((NodeContainer)((Object)notationElement), notationInfoElement);
        }
    }

    protected void addEdge(Node node, SemanticElement semanticElement, Element notationInfoElement) {
        String notationElementId = NotationMapping.getNotationElementId(semanticElement.getElementId());
        Edge notationElement = (Edge)node.getFactory().create(notationElementId);
        notationElement.setSemanticElement(semanticElement);
        notationElement.register();
        node.addLeavingEdge(notationElement);
        semanticElement.addPropertyChangeListener(notationElement);
        this.processEdge(notationElement, notationInfoElement);
    }

    protected void addDimension(RootContainer processDefinitionNotationElement, Element processDiagramInfo) {
        String width = processDiagramInfo.attributeValue("width");
        String height = processDiagramInfo.attributeValue("height");
        Dimension dimension = new Dimension(width == null ? 0 : Integer.valueOf(width), height == null ? 0 : Integer.valueOf(height));
        processDefinitionNotationElement.setDimension(dimension);
    }

    protected void processNode(Node node, Element notationInfoElement) {
        this.addConstraint(node, notationInfoElement);
        this.addEdges(node, notationInfoElement);
    }

    protected void processEdge(Edge edge, Element edgeInfo) {
        this.processLabel(edge, edgeInfo);
        this.addBendpoints(edge, edgeInfo);
    }

    protected void addBendpoints(Edge edge, Element edgeInfo) {
        if (edgeInfo != null) {
            List list = edgeInfo.elements("bendpoint");
            int i = 0;
            while (i < list.size()) {
                this.addBendpoint(edge, (Element)list.get(i), i);
                ++i;
            }
        }
    }

    protected BendPoint addBendpoint(Edge edge, Element bendpointInfo, int index) {
        BendPoint result = new BendPoint();
        this.processBendpoint(result, bendpointInfo);
        edge.addBendPoint(result);
        return result;
    }

    protected void processBendpoint(BendPoint bendPoint, Element bendpointInfo) {
        int w1 = Integer.valueOf(bendpointInfo.attributeValue("w1"));
        int h1 = Integer.valueOf(bendpointInfo.attributeValue("h1"));
        int w2 = Integer.valueOf(bendpointInfo.attributeValue("w2"));
        int h2 = Integer.valueOf(bendpointInfo.attributeValue("h2"));
        Dimension d1 = new Dimension(w1, h1);
        Dimension d2 = new Dimension(w2, h2);
        bendPoint.setRelativeDimensions(d1, d2);
    }

    private void processLabel(Edge edge, Element edgeInfo) {
        Object label = null;
        if (edgeInfo != null) {
            edgeInfo.element("label");
        }
        if (label != null) {
            Point offset = new Point();
            offset.x = Integer.valueOf(label.attributeValue("x"));
            offset.y = Integer.valueOf(label.attributeValue("y"));
            edge.getLabel().setOffset(offset);
        }
    }

    private void addConstraint(Node node, Element nodeInfo) {
        Rectangle constraint = node.getConstraint().getCopy();
        Dimension initialDimension = NotationMapping.getInitialDimension(node.getSemanticElement().getElementId());
        if (initialDimension != null) {
            constraint.setSize(initialDimension);
        }
        if (nodeInfo != null) {
            constraint.x = Integer.valueOf(nodeInfo.attributeValue("x"));
            constraint.y = Integer.valueOf(nodeInfo.attributeValue("y"));
            constraint.width = Integer.valueOf(nodeInfo.attributeValue("width"));
            constraint.height = Integer.valueOf(nodeInfo.attributeValue("height"));
        }
        node.setConstraint(constraint);
    }

    protected void postProcess(NodeContainer nodeContainer) {
        List nodes = nodeContainer.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            Node node = (Node)nodes.get(i);
            List edges = node.getLeavingEdges();
            int j = 0;
            while (j < edges.size()) {
                Edge edge = (Edge)edges.get(j);
                SemanticElement destination = this.findDestination(edge, node);
                Node target = (Node)edge.getFactory().getRegisteredNotationElementFor(destination);
                if (target != null) {
                    target.addArrivingEdge(edge);
                }
                ++j;
            }
            if (node instanceof NodeContainer) {
                this.postProcess((NodeContainer)((Object)node));
            }
            ++i;
        }
    }

    public boolean saveToInput(IEditorInput input, RootContainer rootContainer) {
        boolean result = true;
        try {
            IFile file = this.getNotationInfoFile(((IFileEditorInput)input).getFile());
            InputStreamReader reader = new InputStreamReader(file.getContents());
            Element notationInfo = new SAXReader().read((Reader)reader).getRootElement();
            if (this.upToDateCheck(notationInfo)) {
                this.getNotationInfoFile(((IFileEditorInput)input).getFile()).setContents((InputStream)new ByteArrayInputStream(this.toNotationInfoXml(rootContainer).getBytes()), true, true, null);
            } else {
                result = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String toNotationInfoXml(RootContainer rootContainer) {
        StringWriter writer = new StringWriter();
        this.write(rootContainer, writer);
        return writer.toString();
    }

    private void write(RootContainer rootContainer, Writer writer) {
        try {
            Document document = DocumentHelper.createDocument();
            Element root = document.addElement("root-container");
            this.write(rootContainer, root);
            XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter(writer));
        }
    }

    private void write(RootContainer rootContainer, Element element) {
        this.addAttribute(element, "name", ((NamedElement)rootContainer.getSemanticElement()).getName());
        this.addAttribute(element, "width", Integer.toString(rootContainer.getDimension().width));
        this.addAttribute(element, "height", Integer.toString(rootContainer.getDimension().height));
        Iterator iter = rootContainer.getNodes().iterator();
        while (iter.hasNext()) {
            this.write((Node)iter.next(), element);
        }
    }

    private void write(Node node, Element element) {
        Element newElement = null;
        newElement = node instanceof AbstractNodeContainer ? this.addElement(element, "node-container") : this.addElement(element, "node");
        this.addAttribute(newElement, "name", ((NamedElement)node.getSemanticElement()).getName());
        this.addAttribute(newElement, "x", String.valueOf(node.getConstraint().x));
        this.addAttribute(newElement, "y", String.valueOf(node.getConstraint().y));
        this.addAttribute(newElement, "width", String.valueOf(node.getConstraint().width));
        this.addAttribute(newElement, "height", String.valueOf(node.getConstraint().height));
        if (node instanceof AbstractNodeContainer) {
            Iterator nodes = ((AbstractNodeContainer)node).getNodes().iterator();
            while (nodes.hasNext()) {
                this.write((Node)nodes.next(), newElement);
            }
        }
        for (Edge edge : node.getLeavingEdges()) {
            this.write(edge, this.addElement(newElement, "edge"));
        }
    }

    private void write(Edge edge, Element element) {
        Point offset = edge.getLabel().getOffset();
        if (offset != null) {
            Element label = this.addElement(element, "label");
            this.addAttribute(label, "x", String.valueOf(offset.x));
            this.addAttribute(label, "y", String.valueOf(offset.y));
        }
        Iterator bendpoints = edge.getBendPoints().iterator();
        while (bendpoints.hasNext()) {
            this.write((BendPoint)bendpoints.next(), this.addElement(element, "bendpoint"));
        }
    }

    private void write(BendPoint bendpoint, Element bendpointElement) {
        this.addAttribute(bendpointElement, "w1", String.valueOf(bendpoint.getFirstRelativeDimension().width));
        this.addAttribute(bendpointElement, "h1", String.valueOf(bendpoint.getFirstRelativeDimension().height));
        this.addAttribute(bendpointElement, "w2", String.valueOf(bendpoint.getSecondRelativeDimension().width));
        this.addAttribute(bendpointElement, "h2", String.valueOf(bendpoint.getSecondRelativeDimension().height));
    }

    private Element addElement(Element element, String elementName) {
        Element newElement = element.addElement(elementName);
        return newElement;
    }

    private void addAttribute(Element e, String attributeName, String value) {
        if (value != null) {
            e.addAttribute(attributeName, value);
        }
    }

    private void createNotationInfoFile(IFile notationInfoFile) {
        try {
            notationInfoFile.create((InputStream)new ByteArrayInputStream(this.createInitialNotationInfo().toString().getBytes()), true, null);
        }
        catch (CoreException e) {
            Logger.logError(e);
        }
    }

    private IFile getNotationInfoFile(IFile semanticInfoFile) {
        IPath semanticInfoPath;
        IPath notationInfoPath;
        IProject project = semanticInfoFile.getProject();
        IFile notationInfoFile = project.getFile(notationInfoPath = (semanticInfoPath = semanticInfoFile.getProjectRelativePath()).removeLastSegments(1).append(this.getNotationInfoFileName(semanticInfoFile.getName())));
        if (!notationInfoFile.exists()) {
            this.createNotationInfoFile(notationInfoFile);
        }
        return notationInfoFile;
    }

    public void addNotationInfo(RootContainer rootContainer, IEditorInput input) {
        try {
            IFile file = this.getNotationInfoFile(((FileEditorInput)input).getFile());
            if (file.exists()) {
                InputStreamReader reader = new InputStreamReader(file.getContents());
                Element notationInfo = new SAXReader().read((Reader)reader).getRootElement();
                boolean changed = this.convertCheck(notationInfo);
                this.processRootContainer(rootContainer, notationInfo);
                if (changed) {
                    file.setContents((InputStream)new ByteArrayInputStream(this.toNotationInfoXml(rootContainer).getBytes()), true, true, null);
                }
            } else {
                file.create((InputStream)new ByteArrayInputStream(this.createInitialNotationInfo().toString().getBytes()), true, null);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private boolean convertCheck(Element notationInfo) {
        MessageDialog dialog;
        boolean changed = false;
        if (("process-diagram".equals(notationInfo.getName()) || "pageflow-diagram".equals(notationInfo.getName())) && (dialog = new MessageDialog(null, "Convert To 3.1.x Format", null, "A file created with an older GPD version was detected. If you open this file it will be converted to the 3.1.x format and overwritten.\nDo you want to continue?", 3, new String[]{"Convert And Open", "Continue Without Converting"}, 0)).open() == 0) {
            this.convertToRootContainer(notationInfo);
            changed = true;
        }
        return changed;
    }

    private boolean upToDateCheck(Element notationInfo) {
        if ("process-diagram".equals(notationInfo.getName()) || "pageflow-diagram".equals(notationInfo.getName())) {
            MessageDialog dialog = new MessageDialog(null, "GPD 3.0.x Format Detected", null, "The file you are trying to save contains GPD 3.0.x information.Saving the file will result in an automatic conversion into the 3.1.x format.It will be impossible to open it with the old GPD.\nDo you want to continue?", 3, new String[]{"Save And Convert", "Cancel"}, 0);
            return dialog.open() == 0;
        }
        return true;
    }

    private void convertToRootContainer(Element notationInfo) {
        notationInfo.setName("root-container");
        this.convertChildrenToEdge(notationInfo);
    }

    private void convertChildrenToEdge(Element element) {
        List list = element.elements();
        int i = 0;
        while (i < list.size()) {
            this.convertToEdge((Element)list.get(i));
            ++i;
        }
    }

    private void convertToEdge(Element element) {
        if ("transition".equals(element.getName())) {
            element.setName("edge");
        }
        this.convertChildrenToEdge(element);
    }
}

